/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class GetPeersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.GetPeersRequest> {
    public GetPeersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.GetPeersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.GetPeersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.GetPeersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> learners;
        List<PeerId> peers;
        if (request.onlyAlive()) {
            peers = ctx.node.listAlivePeers();
            learners = ctx.node.listAliveLearners();
        } else {
            peers = ctx.node.listPeers();
            learners = ctx.node.listLearners();
        }
        return this.msgFactory().getPeersResponse().peersList(peers.stream().map(Object::toString).collect(Collectors.toList())).learnersList(learners.stream().map(Object::toString).collect(Collectors.toList())).build();
    }

    @Override
    public String interest() {
        return CliRequests.GetPeersRequest.class.getName();
    }
}

