/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;

class LRUCacheEntryManager<FK, SK, V>
implements ICacheEntryManager<FK, SK, V, LRUCacheEntry<SK, V>> {
    private static final int SLOT_NUM = 128;
    private final LRULinkedList[] lruLinkedLists = new LRULinkedList[128];
    private final Random idxGenerator = new Random();

    LRUCacheEntryManager() {
    }

    @Override
    public LRUCacheEntry<SK, V> createCacheEntry(SK secondKey, V value, ICacheEntryGroup<FK, SK, V, LRUCacheEntry<SK, V>> cacheEntryGroup) {
        return new LRUCacheEntry(secondKey, value, cacheEntryGroup);
    }

    @Override
    public void access(LRUCacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).moveToHead(cacheEntry);
    }

    @Override
    public void put(LRUCacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).add(cacheEntry);
    }

    @Override
    public boolean invalidate(LRUCacheEntry<SK, V> cacheEntry) {
        if (((LRUCacheEntry)cacheEntry).isInvalidated.getAndSet(true)) {
            return false;
        }
        ((LRUCacheEntry)cacheEntry).next.pre = ((LRUCacheEntry)cacheEntry).pre;
        ((LRUCacheEntry)cacheEntry).pre.next = ((LRUCacheEntry)cacheEntry).next;
        ((LRUCacheEntry)cacheEntry).next = null;
        ((LRUCacheEntry)cacheEntry).pre = null;
        return true;
    }

    @Override
    public LRUCacheEntry<SK, V> evict() {
        int startIndex = this.idxGenerator.nextInt(128);
        for (int i = 0; i < 128; ++i) {
            LRUCacheEntry cacheEntry;
            LRULinkedList lruLinkedList;
            if (startIndex == 128) {
                startIndex = 0;
            }
            if ((lruLinkedList = this.lruLinkedLists[startIndex]) != null && (cacheEntry = lruLinkedList.evict()) != null) {
                return cacheEntry;
            }
            ++startIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            for (int i = 0; i < 128; ++i) {
                this.lruLinkedLists[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LRULinkedList getBelongedList(LRUCacheEntry<SK, V> cacheEntry) {
        int slotIndex = cacheEntry.hashCode() % 128;
        slotIndex = slotIndex < 0 ? slotIndex + 128 : slotIndex;
        LRULinkedList lruLinkedList = this.lruLinkedLists[slotIndex];
        if (lruLinkedList != null) return lruLinkedList;
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            lruLinkedList = this.lruLinkedLists[slotIndex];
            if (lruLinkedList != null) return lruLinkedList;
            this.lruLinkedLists[slotIndex] = lruLinkedList = new LRULinkedList();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lruLinkedList;
        }
    }

    private static class LRULinkedList<SK, V> {
        private final LRUCacheEntry<SK, V> head = new LRUCacheEntry(null, null, null);
        private final LRUCacheEntry<SK, V> tail = new LRUCacheEntry(null, null, null);

        public LRULinkedList() {
            ((LRUCacheEntry)this.head).next = (LRUCacheEntry)this.tail;
            ((LRUCacheEntry)this.tail).pre = (LRUCacheEntry)this.head;
        }

        synchronized void add(LRUCacheEntry<SK, V> cacheEntry) {
            LRUCacheEntry nextEntry;
            while ((nextEntry = ((LRUCacheEntry)this.head).next).isInvalidated.get()) {
            }
            ((LRUCacheEntry)cacheEntry).next = ((LRUCacheEntry)this.head).next;
            ((LRUCacheEntry)cacheEntry).pre = (LRUCacheEntry)this.head;
            ((LRUCacheEntry)this.head).next.pre = (LRUCacheEntry)cacheEntry;
            ((LRUCacheEntry)this.head).next = (LRUCacheEntry)cacheEntry;
        }

        synchronized LRUCacheEntry<SK, V> evict() {
            LRUCacheEntry cacheEntry;
            do {
                if ((cacheEntry = ((LRUCacheEntry)this.tail).pre) != this.head) continue;
                return null;
            } while (cacheEntry.isInvalidated.compareAndSet(false, true));
            cacheEntry.pre.next = cacheEntry.next;
            cacheEntry.next.pre = cacheEntry.pre;
            cacheEntry.next = null;
            cacheEntry.pre = null;
            return cacheEntry;
        }

        synchronized void moveToHead(LRUCacheEntry<SK, V> cacheEntry) {
            if (((LRUCacheEntry)cacheEntry).isInvalidated.get()) {
                return;
            }
            ((LRUCacheEntry)cacheEntry).pre.next = ((LRUCacheEntry)cacheEntry).next;
            ((LRUCacheEntry)cacheEntry).next.pre = ((LRUCacheEntry)cacheEntry).pre;
            ((LRUCacheEntry)cacheEntry).next = ((LRUCacheEntry)this.head).next;
            ((LRUCacheEntry)cacheEntry).pre = (LRUCacheEntry)this.head;
            ((LRUCacheEntry)this.head).next.pre = (LRUCacheEntry)cacheEntry;
            ((LRUCacheEntry)this.head).next = (LRUCacheEntry)cacheEntry;
        }
    }

    static class LRUCacheEntry<SK, V>
    implements ICacheEntry<SK, V> {
        private final SK secondKey;
        private volatile ICacheEntryGroup cacheEntryGroup;
        private V value;
        private LRUCacheEntry<SK, V> pre;
        private LRUCacheEntry<SK, V> next;
        private final AtomicBoolean isInvalidated = new AtomicBoolean(false);

        private LRUCacheEntry(SK secondKey, V value, ICacheEntryGroup cacheEntryGroup) {
            this.secondKey = secondKey;
            this.value = value;
            this.cacheEntryGroup = cacheEntryGroup;
        }

        @Override
        public SK getSecondKey() {
            return this.secondKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public ICacheEntryGroup getBelongedGroup() {
            return this.cacheEntryGroup;
        }

        @Override
        public void setBelongedGroup(ICacheEntryGroup belongedGroup) {
            this.cacheEntryGroup = belongedGroup;
        }

        @Override
        public void replaceValue(V newValue) {
            this.value = newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LRUCacheEntry that = (LRUCacheEntry)o;
            return Objects.equals(this.secondKey, that.secondKey) && Objects.equals(this.cacheEntryGroup, that.cacheEntryGroup);
        }

        public int hashCode() {
            return this.cacheEntryGroup.hashCode() * 31 + this.secondKey.hashCode();
        }
    }
}

