/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.model.MessageIdDto;
import org.apache.mailet.ArbitrarySerializable;
import org.apache.mailet.Serializer;

public class AttributeValue<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final T value;
    private final Serializer<T> serializer;

    public static AttributeValue<Boolean> of(Boolean value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Boolean>(value, Serializer.BOOLEAN_SERIALIZER);
    }

    public static AttributeValue<String> of(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<String>(value, Serializer.STRING_SERIALIZER);
    }

    public static AttributeValue<byte[]> of(byte[] value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<byte[]>(value, Serializer.BYTES_SERIALIZER);
    }

    public static AttributeValue<Integer> of(Integer value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Integer>(value, Serializer.INT_SERIALIZER);
    }

    public static AttributeValue<Long> of(Long value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Long>(value, Serializer.LONG_SERIALIZER);
    }

    public static AttributeValue<Float> of(Float value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Float>(value, Serializer.FLOAT_SERIALIZER);
    }

    public static AttributeValue<ZonedDateTime> of(ZonedDateTime value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<ZonedDateTime>(value, Serializer.DATE_SERIALIZER);
    }

    public static AttributeValue<Double> of(Double value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<Double>(value, Serializer.DOUBLE_SERIALIZER);
    }

    public static AttributeValue<MessageIdDto> of(MessageIdDto value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<MessageIdDto>(value, Serializer.MESSAGE_ID_DTO_SERIALIZER);
    }

    public static <T extends ArbitrarySerializable<T>> AttributeValue<T> of(T value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return new AttributeValue<T>(value, new Serializer.ArbitrarySerializableSerializer());
    }

    public static AttributeValue<URL> of(URL value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        return new AttributeValue<URL>(value, Serializer.URL_SERIALIZER);
    }

    public static <T> AttributeValue<Optional<AttributeValue<T>>> of(Optional<AttributeValue<T>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        Preconditions.checkArgument((boolean)value.map(v -> v instanceof AttributeValue).orElse(true), (Object)"value should be of type Optional<AttributeValue<T>> and was not");
        return new AttributeValue<Optional<AttributeValue<T>>>(value, new Serializer.OptionalSerializer());
    }

    public static AttributeValue<Collection<AttributeValue<?>>> of(Collection<AttributeValue<?>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        Preconditions.checkArgument((boolean)value.stream().allMatch(entry -> entry instanceof AttributeValue), (Object)"Expecting Collection<AttributeValue<?>: invalid typing.");
        return new AttributeValue(value, new Serializer.CollectionSerializer());
    }

    public static AttributeValue<Map<String, AttributeValue<?>>> of(Map<String, AttributeValue<?>> value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        Preconditions.checkArgument((boolean)value.entrySet().stream().allMatch(entry -> entry.getKey() instanceof String && entry.getValue() instanceof AttributeValue), (Object)"Expecting Map<String, AttributeValue<?>>: invalid typing.");
        return new AttributeValue(value, new Serializer.MapSerializer());
    }

    public static AttributeValue<Object> ofUnserializable(Object any) {
        Preconditions.checkNotNull((Object)any, (Object)"value should not be null");
        return new AttributeValue<Object>(any, new Serializer.NoSerializer());
    }

    public static AttributeValue<?> ofAny(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        if (value instanceof Boolean) {
            return AttributeValue.of((Boolean)value);
        }
        if (value instanceof String) {
            return AttributeValue.of((String)value);
        }
        if (value instanceof byte[]) {
            return AttributeValue.of((byte[])value);
        }
        if (value instanceof Integer) {
            return AttributeValue.of((Integer)value);
        }
        if (value instanceof Long) {
            return AttributeValue.of((Long)value);
        }
        if (value instanceof Float) {
            return AttributeValue.of((Float)value);
        }
        if (value instanceof Double) {
            return AttributeValue.of((Double)value);
        }
        if (value instanceof ZonedDateTime) {
            return AttributeValue.of((ZonedDateTime)value);
        }
        if (value instanceof Collection) {
            return AttributeValue.of((Collection)value);
        }
        if (value instanceof Map) {
            return AttributeValue.of((Map)value);
        }
        if (value instanceof MessageIdDto) {
            return AttributeValue.of((MessageIdDto)value);
        }
        if (value instanceof ArbitrarySerializable) {
            return AttributeValue.of((ArbitrarySerializable)value);
        }
        if (value instanceof URL) {
            return AttributeValue.of((URL)value);
        }
        if (value instanceof Optional) {
            return AttributeValue.of((Optional)value);
        }
        throw new IllegalArgumentException(value.getClass().toString() + " is not a managed attibute");
    }

    public static AttributeValue<?> fromJsonString(String json) throws IOException {
        JsonNode tree = OBJECT_MAPPER.readTree(json);
        return AttributeValue.fromJson(tree);
    }

    public static AttributeValue<?> fromJson(JsonNode input) {
        return Optional.ofNullable(input).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).flatMap(AttributeValue::deserialize).map(AttributeValue::ofAny).orElseThrow(() -> new IllegalStateException("unable to deserialize " + input.toString()));
    }

    public static Optional<?> deserialize(ObjectNode fields) {
        Preconditions.checkNotNull((Object)fields);
        Optional<JsonNode> maybeSerializer = Optional.ofNullable(fields.get("serializer"));
        Optional<JsonNode> maybeValue = Optional.ofNullable(fields.get("value"));
        return maybeSerializer.flatMap(serializer -> maybeValue.flatMap(value -> AttributeValue.findSerializerAndDeserialize(serializer, value)));
    }

    public static Optional<?> findSerializerAndDeserialize(JsonNode serializer, JsonNode value) {
        return Serializer.Registry.find(serializer.asText()).flatMap(s -> s.deserialize(value));
    }

    private AttributeValue(T value, Serializer<T> serializer) {
        this.value = value;
        this.serializer = serializer;
    }

    public T value() {
        return this.value;
    }

    public <U> Optional<U> valueAs(Class<U> type) {
        return this.asAttributeValueOf(type).map(AttributeValue::value);
    }

    public <U> Optional<AttributeValue<U>> asAttributeValueOf(Class<U> type) {
        if (type.isInstance(this.value)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public <U> Optional<AttributeValue<Map<String, AttributeValue<U>>>> asMapAttributeValueOf(Class<U> type) {
        if (this.value instanceof Map) {
            Map aMap = (Map)this.value;
            Map castedMap = (Map)aMap.entrySet().stream().flatMap(entry -> ((AttributeValue)entry.getValue()).asAttributeValueOf(type).stream().map(castedValue -> Pair.of((Object)((String)entry.getKey()), (Object)castedValue))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
            return Optional.of(new AttributeValue<Map>(castedMap, new Serializer.MapSerializer()));
        }
        return Optional.empty();
    }

    public AttributeValue<T> duplicate() {
        return new AttributeValue<T>(this.serializer.duplicate(this.value), this.serializer);
    }

    public Optional<JsonNode> toJson() {
        return this.serializer.serialize(this.value).map(value -> {
            ObjectNode serialized = JsonNodeFactory.instance.objectNode();
            serialized.put("serializer", this.serializer.getName());
            serialized.replace("value", value);
            return serialized;
        });
    }

    public T getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof AttributeValue) {
            AttributeValue that = (AttributeValue)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.serializer, that.serializer);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.serializer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("serializer", (Object)this.serializer.getName()).toString();
    }
}

