/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.apache.commons.io.input.UnsynchronizedBufferedInputStream;
import org.apache.commons.io.input.UnsynchronizedFilterInputStream;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.transport.InitJCE;
import org.apache.james.transport.KeyStoreHolder;
import org.apache.james.transport.KeyStoreHolderConfiguration;
import org.apache.james.transport.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreHolderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreHolderFactory.class);
    private static final String DEFAULT_KEYSTORE_FILE_PATH = "file://" + System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
    private final FileSystem fileSystem;

    public static KeyStoreHolderFactory from(FileSystem fileSystem) {
        return new KeyStoreHolderFactory(fileSystem);
    }

    private KeyStoreHolderFactory(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public KeyStoreHolder createKeyStoreHolder(KeyStoreHolderConfiguration config) throws MessagingException {
        try {
            KeyStoreHolderFactory.initJCE();
            return config.getFileLoader(this.fileSystem).load(config);
        }
        catch (Exception e) {
            throw new MessagingException("Error loading the trusted certificate store", e);
        }
    }

    private static void initJCE() throws NoSuchProviderException {
        try {
            InitJCE.init();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
    }

    static interface FileLoader {
        public KeyStoreHolder load(KeyStoreHolderConfiguration var1) throws Exception;
    }

    static class PemFileLoader
    implements FileLoader {
        private final FileSystem fileSystem;

        public PemFileLoader(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public KeyStoreHolder load(KeyStoreHolderConfiguration config) throws Exception {
            KeyStoreHolderConfiguration.PemConfiguration pemConfig = (KeyStoreHolderConfiguration.PemConfiguration)config;
            KeyStore keyStore = PemReader.loadTrustStore(this.fileSystem.getFile(pemConfig.getPemFileName()));
            if (keyStore.size() == 0) {
                throw new KeyStoreException("The keystore must be not empty");
            }
            return new KeyStoreHolder(keyStore);
        }
    }

    static class KeyStoreFileLoader
    implements FileLoader {
        private final FileSystem fileSystem;

        public KeyStoreFileLoader(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public KeyStoreHolder load(KeyStoreHolderConfiguration config) {
            KeyStoreHolderConfiguration.KeyStoreConfiguration keyStoreConfig = (KeyStoreHolderConfiguration.KeyStoreConfiguration)config;
            return (KeyStoreHolder)keyStoreConfig.getKeyStoreFileName().map(Throwing.function(fileName -> this.createFromKeyStoreFile((String)fileName, keyStoreConfig.getKeyStorePassword(), keyStoreConfig.getKeyStoreType()))).orElseGet(Throwing.supplier(() -> {
                LOGGER.info("No trusted store path specified, using default store.");
                return this.createFromKeyStoreFile(DEFAULT_KEYSTORE_FILE_PATH, keyStoreConfig.getKeyStorePassword(), KeyStore.getDefaultType());
            }));
        }

        private KeyStoreHolder createFromKeyStoreFile(String keyStoreFileName, String keyStorePassword, String keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load((InputStream)((UnsynchronizedFilterInputStream.Builder)UnsynchronizedBufferedInputStream.builder().setInputStream(this.fileSystem.getResource(keyStoreFileName))).get(), keyStorePassword.toCharArray());
            if (keyStore.size() == 0) {
                throw new KeyStoreException("The keystore must be not empty");
            }
            return new KeyStoreHolder(keyStore);
        }
    }
}

