/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.transport.KeyStoreHolder;
import org.apache.james.transport.KeyStoreHolderConfiguration;
import org.apache.james.transport.KeyStoreHolderFactory;
import org.apache.james.transport.SMIMESignerInfo;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.eclipse.angus.mail.util.BASE64DecoderStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMECheckSignature
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMECheckSignature.class);
    private static final String SMIME_STATUS_HEADER = "X-SMIME-Status";
    private final FileSystem fileSystem;
    private KeyStoreHolder trustedCertificateStore;
    private boolean stripSignature = false;
    private boolean onlyTrusted = true;
    private AttributeName mailAttribute = AttributeName.of((String)"org.apache.james.SMIMECheckSignature");

    @Inject
    public SMIMECheckSignature(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void init() throws MessagingException {
        String mailAttributeConf;
        String onlyTrustedConf;
        MailetConfig config = this.getMailetConfig();
        String stripSignatureConf = config.getInitParameter("strip");
        if (stripSignatureConf != null) {
            this.stripSignature = Boolean.parseBoolean(stripSignatureConf);
        }
        if ((onlyTrustedConf = config.getInitParameter("onlyTrusted")) != null) {
            this.onlyTrusted = Boolean.parseBoolean(onlyTrustedConf);
        }
        if ((mailAttributeConf = config.getInitParameter("mailAttribute")) != null) {
            this.mailAttribute = AttributeName.of((String)mailAttributeConf);
        }
        this.trustedCertificateStore = KeyStoreHolderFactory.from(this.fileSystem).createKeyStoreHolder(KeyStoreHolderConfiguration.from(config));
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        MimeBodyPart strippedMessage = null;
        List<SMIMESignerInfo> signers = null;
        boolean isMessageSigned = false;
        boolean isSignatureGood = false;
        try {
            SMIMESigned signed = this.asSMIMESigned(message);
            if (signed != null) {
                signers = this.trustedCertificateStore.verifySignatures(signed);
                strippedMessage = signed.getContent();
                isMessageSigned = true;
            } else {
                LOGGER.info("Content not identified as signed");
            }
        }
        catch (CMSException | SMIMEException e) {
            LOGGER.error("Error during the analysis of the signed message", e);
            signers = null;
        }
        catch (IOException e) {
            LOGGER.error("IO error during the analysis of the signed message", (Throwable)e);
            signers = null;
        }
        catch (Exception e) {
            LOGGER.error("Generic error occured during the analysis of the message", (Throwable)e);
            signers = null;
        }
        if (signers != null) {
            ArrayList<AttributeValue<?>> signerinfolist = this.signerInfoList(signers);
            if (!signerinfolist.isEmpty()) {
                mail.setAttribute(new Attribute(this.mailAttribute, AttributeValue.of(signerinfolist)));
                isSignatureGood = true;
            } else {
                strippedMessage = null;
            }
        }
        this.setSMIMEStatus(mail, isMessageSigned, isSignatureGood);
        if (this.stripSignature && strippedMessage != null) {
            this.stripSignature(mail, message, strippedMessage);
        }
    }

    private void setSMIMEStatus(Mail mail, boolean isMessageSigned, boolean isSignatureGood) throws MessagingException {
        if (!isMessageSigned) {
            mail.getMessage().setHeader(SMIME_STATUS_HEADER, "Not signed");
        } else if (isSignatureGood) {
            mail.getMessage().setHeader(SMIME_STATUS_HEADER, "Good signature");
        } else {
            mail.getMessage().setHeader(SMIME_STATUS_HEADER, "Bad signature");
        }
    }

    private ArrayList<AttributeValue<?>> signerInfoList(List<SMIMESignerInfo> signers) {
        ArrayList signerinfolist = new ArrayList();
        for (SMIMESignerInfo info : signers) {
            if (!info.isSignValid() || this.onlyTrusted && info.getCertPath() == null) continue;
            try {
                signerinfolist.add(AttributeValue.of((byte[])info.getSignerCertificate().getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("Failed to encode certificate", (Throwable)e);
            }
        }
        return signerinfolist;
    }

    private void stripSignature(Mail mail, MimeMessage message, MimeBodyPart strippedMessage) throws MessagingException {
        try {
            Object obj = strippedMessage.getContent();
            if (obj instanceof Multipart) {
                message.setContent((Multipart)obj);
            } else {
                message.setContent(obj, strippedMessage.getContentType());
            }
            message.saveChanges();
            mail.setMessage(message);
        }
        catch (Exception e) {
            throw new MessagingException("Error during the extraction of the signed content from the message.", e);
        }
    }

    private SMIMESigned asSMIMESigned(MimeMessage message) throws IOException, MessagingException, CMSException, SMIMEException {
        Object obj = message.getContent();
        Object signed = obj instanceof MimeMultipart ? new SMIMESigned((MimeMultipart)message.getContent()) : (obj instanceof SMIMESigned ? (SMIMESigned)obj : (obj instanceof byte[] || obj instanceof BASE64DecoderStream ? new SMIMESigned((Part)message) : null));
        return signed;
    }
}

