/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.InvocationContext;
import feign.Logger;
import feign.Response;
import feign.ResponseInterceptor;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.lang.reflect.Type;

public class ResponseHandler {
    private final Logger.Level logLevel;
    private final Logger logger;
    private final Decoder decoder;
    private final ErrorDecoder errorDecoder;
    private final boolean dismiss404;
    private final boolean closeAfterDecode;
    private final boolean decodeVoid;
    private final ResponseInterceptor.Chain executionChain;

    public ResponseHandler(Logger.Level logLevel, Logger logger, Decoder decoder, ErrorDecoder errorDecoder, boolean dismiss404, boolean closeAfterDecode, boolean decodeVoid, ResponseInterceptor.Chain executionChain) {
        this.logLevel = logLevel;
        this.logger = logger;
        this.decoder = decoder;
        this.errorDecoder = errorDecoder;
        this.dismiss404 = dismiss404;
        this.closeAfterDecode = closeAfterDecode;
        this.decodeVoid = decodeVoid;
        this.executionChain = executionChain;
    }

    public Object handleResponse(String configKey, Response response, Type returnType, long elapsedTime) throws Exception {
        try {
            response = this.logAndRebufferResponseIfNeeded(configKey, response, elapsedTime);
            return this.executionChain.next(new InvocationContext(configKey, this.decoder, this.errorDecoder, this.dismiss404, this.closeAfterDecode, this.decodeVoid, response, returnType));
        }
        catch (IOException e) {
            if (this.logLevel != Logger.Level.NONE) {
                this.logger.logIOException(configKey, this.logLevel, e, elapsedTime);
            }
            throw FeignException.errorReading(response.request(), response, e);
        }
        catch (Exception e) {
            Util.ensureClosed(response.body());
            throw e;
        }
    }

    private Response logAndRebufferResponseIfNeeded(String configKey, Response response, long elapsedTime) throws IOException {
        if (this.logLevel == Logger.Level.NONE) {
            return response;
        }
        return this.logger.logAndRebufferResponse(configKey, this.logLevel, response, elapsedTime);
    }
}

