/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import it.unimi.dsi.fastutil.Pair;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.util.DurationParser;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class IMAPCommandsThrottler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IMAPCommandsThrottler.class);
    private final ThrottlerConfiguration configuration;

    public IMAPCommandsThrottler(ThrottlerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ImapRequest) {
            ImapRequest imapRequest = (ImapRequest)msg;
            String key = imapRequest.getCommand().getName().toUpperCase(Locale.US);
            Optional.ofNullable(this.configuration.entryMap().get(key)).ifPresentOrElse(configurationEntry -> IMAPCommandsThrottler.throttle(ctx, msg, imapRequest, configurationEntry), () -> ctx.fireChannelRead(msg));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private static void throttle(ChannelHandlerContext ctx, Object msg, ImapRequest imapRequest, ThrottlerConfigurationEntry configurationEntry) {
        ImapSession session = (ImapSession)ctx.channel().attr(NettyConstants.IMAP_SESSION_ATTRIBUTE_KEY);
        AtomicLong atomicLong = IMAPCommandsThrottler.retrieveAssociatedCounter(imapRequest, session, configurationEntry);
        Duration delay = Duration.ofMillis(configurationEntry.delayMSFor(atomicLong.getAndIncrement()));
        if (delay.isPositive()) {
            IMAPCommandsThrottler.logDelay(imapRequest, session, delay);
            Mono.delay((Duration)delay).then(Mono.fromRunnable(() -> ctx.fireChannelRead(msg))).subscribeOn(Schedulers.parallel()).subscribe();
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private static AtomicLong retrieveAssociatedCounter(ImapRequest imapRequest, ImapSession session, ThrottlerConfigurationEntry entry) {
        String key = "imap-applicative-traffic-shaper-counter-" + imapRequest.getCommand().getName();
        return Optional.ofNullable(session.getAttribute(key)).filter(AtomicLong.class::isInstance).map(AtomicLong.class::cast).orElseGet(() -> {
            AtomicLong res = new AtomicLong(0L);
            session.setAttribute(key, (Object)res);
            session.schedule(() -> session.setAttribute(key, (Object)new AtomicLong(0L)), entry.observationPeriod());
            return res;
        });
    }

    private static void logDelay(ImapRequest imapRequest, ImapSession session, Duration delay) {
        MDCStructuredLogger.forLogger((Logger)LOGGER).field("username", session.getUserName().asString()).field("userAgent", Optional.ofNullable(session.getAttribute("userAgent")).filter(String.class::isInstance).map(String.class::cast).orElse("")).log(logger -> logger.info("Delayed command {} on an IMAP session. Delay {} ms", (Object)imapRequest.getCommand().getName(), (Object)delay.toMillis()));
    }

    public record ThrottlerConfiguration(Map<String, ThrottlerConfigurationEntry> entryMap) {
        public static ThrottlerConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) {
            return new ThrottlerConfiguration((Map)((ImmutableNode)configuration.getNodeModel().getNodeHandler().getRootNode()).getChildren().stream().map(key -> Pair.of((Object)key.getNodeName().toUpperCase(Locale.US), (Object)ThrottlerConfigurationEntry.from(configuration.immutableConfigurationAt(key.getNodeName())))).collect(ImmutableMap.toImmutableMap(Pair::key, Pair::value)));
        }
    }

    public record ThrottlerConfigurationEntry(int thresholdCount, Duration additionalDelayPerOperation, Duration observationPeriod, Duration maxDelay) {
        public static ThrottlerConfigurationEntry from(ImmutableHierarchicalConfiguration configuration) {
            return new ThrottlerConfigurationEntry(Optional.ofNullable(configuration.getString("thresholdCount", null)).map(Integer::parseInt).orElseThrow(() -> new IllegalArgumentException("thresholdCount in compulsory for ThrottlerConfigurationEntry")), Optional.ofNullable(configuration.getString("additionalDelayPerOperation", null)).map(DurationParser::parse).orElseThrow(() -> new IllegalArgumentException("additionalDelayPerOperation in compulsory for ThrottlerConfigurationEntry")), Optional.ofNullable(configuration.getString("observationPeriod", null)).map(DurationParser::parse).orElseThrow(() -> new IllegalArgumentException("observationPeriod in compulsory for ThrottlerConfigurationEntry")), Optional.ofNullable(configuration.getString("maxDelay", null)).map(DurationParser::parse).orElseThrow(() -> new IllegalArgumentException("maxDelay in compulsory for ThrottlerConfigurationEntry")));
        }

        long delayMSFor(long occurrenceCount) {
            if (occurrenceCount < (long)this.thresholdCount) {
                return 0L;
            }
            return Math.min(this.maxDelay.toMillis(), occurrenceCount * this.additionalDelayPerOperation.toMillis());
        }
    }
}

