/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Query
implements FrontendMessage {
    private final String query;

    public Query(String query) {
        this.query = Assert.requireNonNull(query, "query must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 81);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.query);
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query that = (Query)o;
        return Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + '}';
    }
}

