/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.CompositeBucket;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CompositeAggregate
extends MultiBucketAggregateBase<CompositeBucket>
implements AggregateVariant {
    private final Map<String, JsonData> afterKey;
    public static final JsonpDeserializer<CompositeAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregate::setupCompositeAggregateDeserializer);

    private CompositeAggregate(Builder builder) {
        super(builder);
        this.afterKey = ApiTypeHelper.unmodifiable(builder.afterKey);
    }

    public static CompositeAggregate of(Function<Builder, ObjectBuilder<CompositeAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Composite;
    }

    public final Map<String, JsonData> afterKey() {
        return this.afterKey;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.afterKey)) {
            generator.writeKey("after_key");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.afterKey.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompositeAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, CompositeBucket._DESERIALIZER);
        op.add(Builder::afterKey, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "after_key");
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<CompositeBucket, Builder>
    implements ObjectBuilder<CompositeAggregate> {
        @Nullable
        private Map<String, JsonData> afterKey;

        public final Builder afterKey(Map<String, JsonData> map) {
            this.afterKey = Builder._mapPutAll(this.afterKey, map);
            return this;
        }

        public final Builder afterKey(String key, JsonData value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregate build() {
            this._checkSingleUse();
            super.tBucketSerializer(null);
            return new CompositeAggregate(this);
        }
    }
}

