/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPBind;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPControl;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPRebind;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPConstraints
implements Serializable {
    private static final long serialVersionUID = 6843729471197926148L;
    private boolean followReferrals = false;
    private int hopLimit = 5;
    private int timeLimit = 0;
    @Nullable
    private LDAPBind bindProc = null;
    @NotNull
    private LDAPControl[] clientControls = new LDAPControl[0];
    @NotNull
    private LDAPControl[] serverControls = new LDAPControl[0];
    @Nullable
    private LDAPRebind rebindProc = null;

    public LDAPConstraints() {
    }

    public LDAPConstraints(int msLimit, boolean doReferrals, @Nullable LDAPBind bindProc, int hopLimit) {
        this();
        this.timeLimit = msLimit;
        this.followReferrals = doReferrals;
        this.bindProc = bindProc;
        this.hopLimit = hopLimit;
    }

    public LDAPConstraints(int msLimit, boolean doReferrals, @Nullable LDAPRebind rebindProc, int hopLimit) {
        this();
        this.timeLimit = msLimit;
        this.followReferrals = doReferrals;
        this.rebindProc = rebindProc;
        this.hopLimit = hopLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit < 0 ? 0 : timeLimit;
    }

    public boolean getReferrals() {
        return this.followReferrals;
    }

    public void setReferrals(boolean doReferrals) {
        this.followReferrals = doReferrals;
    }

    @Nullable
    public LDAPBind getBindProc() {
        return this.bindProc;
    }

    public void setBindProc(@Nullable LDAPBind bindProc) {
        this.bindProc = bindProc;
    }

    @Nullable
    public LDAPRebind getRebindProc() {
        return this.rebindProc;
    }

    public void setRebindProc(@Nullable LDAPRebind rebindProc) {
        this.rebindProc = rebindProc;
    }

    public int getHopLimit() {
        return this.hopLimit;
    }

    public void setHopLimit(int hopLimit) {
        this.hopLimit = hopLimit < 0 ? 0 : hopLimit;
    }

    @NotNull
    public LDAPControl[] getClientControls() {
        return this.clientControls;
    }

    public void setClientControls(@NotNull LDAPControl control) {
        this.clientControls = new LDAPControl[]{control};
    }

    public void setClientControls(@Nullable LDAPControl[] controls) {
        this.clientControls = controls == null ? new LDAPControl[0] : controls;
    }

    @NotNull
    public LDAPControl[] getServerControls() {
        return this.serverControls;
    }

    public void setServerControls(@NotNull LDAPControl control) {
        this.serverControls = new LDAPControl[]{control};
    }

    public void setServerControls(@Nullable LDAPControl[] controls) {
        this.serverControls = controls == null ? new LDAPControl[0] : controls;
    }

    @NotNull
    public LDAPConstraints duplicate() {
        LDAPConstraints c = new LDAPConstraints();
        c.bindProc = this.bindProc;
        c.clientControls = this.clientControls;
        c.followReferrals = this.followReferrals;
        c.hopLimit = this.hopLimit;
        c.rebindProc = this.rebindProc;
        c.serverControls = this.serverControls;
        c.timeLimit = this.timeLimit;
        return c;
    }

    @NotNull
    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append("LDAPConstraints(followReferrals=");
        buffer.append(this.followReferrals);
        buffer.append(", bindProc=");
        buffer.append(String.valueOf(this.bindProc));
        buffer.append(", rebindProc=");
        buffer.append(String.valueOf(this.rebindProc));
        buffer.append(", hopLimit=");
        buffer.append(this.hopLimit);
        buffer.append(", timeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(", clientControls={");
        for (i = 0; i < this.clientControls.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.clientControls[i].toString());
        }
        buffer.append("}, serverControls={");
        for (i = 0; i < this.serverControls.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.serverControls[i].toString());
        }
        buffer.append("})");
        return buffer.toString();
    }
}

