/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.LinkedHashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OIDRegistryItem
implements Serializable {
    @NotNull
    private static final String FIELD_NAME = "name";
    @NotNull
    private static final String FIELD_OID = "oid";
    @NotNull
    private static final String FIELD_ORIGIN = "origin";
    @NotNull
    private static final String FIELD_TYPE = "type";
    @NotNull
    private static final String FIELD_URL = "url";
    private static final long serialVersionUID = 4342220623592884938L;
    @NotNull
    private final JSONObject jsonObject;
    @NotNull
    private final String name;
    @NotNull
    private final String oid;
    @Nullable
    private final String origin;
    @NotNull
    private final String type;
    @Nullable
    private final String url;

    OIDRegistryItem(@NotNull String oid, @NotNull String name, @NotNull String type, @Nullable String origin, @Nullable String url) {
        this.oid = oid;
        this.name = name;
        this.type = type;
        this.origin = origin;
        this.url = url;
        LinkedHashMap<String, JSONValue> jsonFields = new LinkedHashMap<String, JSONValue>();
        jsonFields.put(FIELD_OID, new JSONString(oid));
        jsonFields.put(FIELD_NAME, new JSONString(name));
        jsonFields.put(FIELD_TYPE, new JSONString(type));
        if (origin != null) {
            jsonFields.put(FIELD_ORIGIN, new JSONString(origin));
        }
        if (url != null) {
            jsonFields.put(FIELD_URL, new JSONString(url));
        }
        this.jsonObject = new JSONObject(jsonFields);
    }

    OIDRegistryItem(@NotNull JSONObject jsonObject) throws LDAPException {
        this.jsonObject = jsonObject;
        this.oid = jsonObject.getFieldAsString(FIELD_OID);
        if (this.oid == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UtilityMessages.ERR_OID_REGISTRY_ITEM_OBJECT_MISSING_FIELD.get(jsonObject.toSingleLineString(), FIELD_OID));
        }
        this.name = jsonObject.getFieldAsString(FIELD_NAME);
        if (this.name == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UtilityMessages.ERR_OID_REGISTRY_ITEM_OBJECT_MISSING_FIELD.get(jsonObject.toSingleLineString(), FIELD_NAME));
        }
        this.type = jsonObject.getFieldAsString(FIELD_TYPE);
        if (this.type == null) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, UtilityMessages.ERR_OID_REGISTRY_ITEM_OBJECT_MISSING_FIELD.get(jsonObject.toSingleLineString(), FIELD_TYPE));
        }
        this.origin = jsonObject.getFieldAsString(FIELD_ORIGIN);
        this.url = jsonObject.getFieldAsString(FIELD_URL);
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Nullable
    public String getURL() {
        return this.url;
    }

    @NotNull
    public JSONObject asJSONObject() {
        return this.jsonObject;
    }

    @NotNull
    public String toString() {
        return this.jsonObject.toSingleLineString();
    }
}

