/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import com.google.common.base.Objects;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.model.Quota;

public class QuotaResponse
implements ImapResponseMessage {
    private final String resourceName;
    private final String quotaRoot;
    private final Quota<?, ?> quota;

    public QuotaResponse(String resource, String quotaRoot, Quota<?, ?> quota) {
        this.quota = quota;
        this.resourceName = resource;
        this.quotaRoot = quotaRoot;
    }

    public Quota<?, ?> getQuota() {
        return this.quota;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getQuotaRoot() {
        return this.quotaRoot;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaResponse) {
            QuotaResponse other = (QuotaResponse)o;
            return Objects.equal((Object)this.quotaRoot, (Object)other.quotaRoot) && Objects.equal((Object)this.resourceName, (Object)other.resourceName) && Objects.equal(this.quota, other.quota);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceName, this.quotaRoot, this.quota});
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("QUOTA").append(' ').append(this.quotaRoot).append(' ').append('(').append(this.resourceName).append(' ').append(this.quota.getUsed()).append(' ').append(this.quota.getLimit()).append(')');
        return result.toString();
    }
}

