/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.codec.StandardBinaryCodec;
import com.github.f4b6a3.uuid.codec.StandardStringCodec;
import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public abstract class UuidFactory {
    protected final UuidVersion version;
    protected final long versionMask;

    public UuidFactory() {
        this.version = UuidVersion.VERSION_UNKNOWN;
        this.versionMask = (long)this.version.getValue() << 12;
    }

    public UuidFactory(UuidVersion version) {
        this.version = version;
        this.versionMask = (long)version.getValue() << 12;
    }

    public UuidVersion getVersion() {
        return this.version;
    }

    public abstract UUID create();

    public abstract UUID create(Parameters var1);

    protected static byte[] nameBytes(byte[] name) {
        Objects.requireNonNull(name, "Null name");
        return Arrays.copyOf(name, name.length);
    }

    protected static byte[] nameBytes(String name) {
        Objects.requireNonNull(name, "Null name");
        return name.getBytes(StandardCharsets.UTF_8);
    }

    protected static byte[] namespaceBytes(UuidNamespace namespace) {
        if (namespace != null) {
            return UuidFactory.namespaceBytes(namespace.getValue());
        }
        return null;
    }

    protected static byte[] namespaceBytes(UUID namespace) {
        if (namespace != null) {
            return StandardBinaryCodec.INSTANCE.encode(namespace);
        }
        return null;
    }

    protected static byte[] namespaceBytes(String namespace) {
        if (namespace != null) {
            return StandardBinaryCodec.INSTANCE.encode(StandardStringCodec.INSTANCE.decode(namespace));
        }
        return null;
    }

    protected UUID toUuid(long msb, long lsb) {
        long msb0 = msb & 0xFFFFFFFFFFFF0FFFL | this.versionMask;
        long lsb0 = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb0, lsb0);
    }

    public static class Parameters {
        private final Instant instant;
        private final byte[] namespace;
        private final byte[] name;
        private final byte localDomain;
        private final int localIdentifier;

        public Parameters(Builder builder) {
            Objects.requireNonNull(builder);
            this.instant = builder.instant;
            this.namespace = builder.namespace;
            this.name = builder.name;
            this.localDomain = builder.localDomain;
            this.localIdentifier = builder.localIdentifier;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public byte[] getNamespace() {
            return this.namespace;
        }

        public byte[] getName() {
            return this.name;
        }

        public byte getLocalDomain() {
            return this.localDomain;
        }

        public int getLocalIdentifier() {
            return this.localIdentifier;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Instant instant;
            private byte[] namespace = null;
            private byte[] name = null;
            private byte localDomain;
            private int localIdentifier;

            private Builder() {
            }

            public Builder withInstant(Instant instant) {
                this.instant = instant;
                return this;
            }

            public Builder withNamespace(UUID namespace) {
                this.namespace = UuidFactory.namespaceBytes(namespace);
                return this;
            }

            public Builder withNamespace(String namespace) {
                this.namespace = UuidFactory.namespaceBytes(namespace);
                return this;
            }

            public Builder withNamespace(UuidNamespace namespace) {
                this.namespace = UuidFactory.namespaceBytes(namespace);
                return this;
            }

            public Builder withName(byte[] name) {
                this.name = UuidFactory.nameBytes(name);
                return this;
            }

            public Builder withName(String name) {
                this.name = UuidFactory.nameBytes(name);
                return this;
            }

            public Builder withLocalDomain(UuidLocalDomain localDomain) {
                this.localDomain = localDomain.getValue();
                return this;
            }

            public Builder withLocalDomain(byte localDomain) {
                this.localDomain = localDomain;
                return this;
            }

            public Builder withLocalIdentifier(int localIdentifier) {
                this.localIdentifier = localIdentifier;
                return this;
            }

            public Parameters build() {
                return new Parameters(this);
            }
        }
    }
}

