/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class StoredScript
implements PlainJsonSerializable {
    private final String lang;
    private final Map<String, String> options;
    private final String source;
    public static final JsonpDeserializer<StoredScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoredScript::setupStoredScriptDeserializer);

    private StoredScript(Builder builder) {
        this.lang = ApiTypeHelper.requireNonNull(builder.lang, this, "lang");
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static StoredScript of(Function<Builder, ObjectBuilder<StoredScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String lang() {
        return this.lang;
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        generator.write(this.lang);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.options.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupStoredScriptDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<StoredScript> {
        private String lang;
        @Nullable
        private Map<String, String> options;
        private String source;

        public final Builder lang(String value) {
            this.lang = value;
            return this;
        }

        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        public StoredScript build() {
            this._checkSingleUse();
            return new StoredScript(this);
        }
    }
}

