/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Meter;
import org.apache.james.metrics.api.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropWizardMetric
implements Metric {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropWizardMetric.class);
    private final Meter meter;
    private final String metricName;

    public DropWizardMetric(Meter meter, String metricName) {
        this.meter = meter;
        this.metricName = metricName;
    }

    public void increment() {
        this.meter.mark();
    }

    public void decrement() {
        this.meter.mark(-1L);
    }

    public void add(int value) {
        this.meter.mark((long)value);
    }

    public void remove(int value) {
        this.meter.mark((long)(-1 * value));
    }

    public long getCount() {
        long value = this.meter.getCount();
        if (value < 0L) {
            LOGGER.error("counter value({}) of the metric '{}' should not be a negative number", (Object)value, (Object)this.metricName);
            return 0L;
        }
        return value;
    }

    public double movingAverage() {
        return this.meter.getFiveMinuteRate();
    }

    public double meanRate() {
        return this.meter.getMeanRate();
    }
}

