/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ_SSE;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemWriter;
import org.apache.jena.sparql.sse.SSE;

public class sse
extends CmdARQ_SSE {
    protected final ArgDecl numberDecl = new ArgDecl(true, "num", "number");
    protected final ArgDecl noPrintDecl = new ArgDecl(false, "n");
    protected final ArgDecl noResolveDecl = new ArgDecl(false, "raw");
    private boolean print = true;
    private boolean structural = true;
    private boolean lineNumbers = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String ... argv) {
        new sse(argv).mainRun();
    }

    public sse(String[] argv) {
        super(argv);
        super.add(this.noPrintDecl, "-n", "Don't print the expression");
        super.add(this.numberDecl, "--num [on|off]", "Numbers");
        super.add(this.noResolveDecl, "--raw", "Don't handle base or prefix names specially");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        boolean bl = this.print = !this.contains(this.noPrintDecl);
        if (this.contains(this.numberDecl)) {
            this.lineNumbers = this.getValue(this.numberDecl).equalsIgnoreCase("on");
        }
        if (this.contains(this.noResolveDecl)) {
            SSE.setUseResolver(false);
        }
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName();
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    @Override
    protected void exec(Item item) {
        if (!this.print) {
            return;
        }
        if (item == null) {
            System.err.println("No expression");
            throw new TerminationException(9);
        }
        this.divider();
        IndentedWriter out = new IndentedWriter(System.out, this.lineNumbers);
        PrefixMapping pmap = null;
        SerializationContext sCxt = new SerializationContext(pmap);
        ItemWriter.write(out, item, sCxt);
        out.ensureStartOfLine();
        out.flush();
    }
}

