/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.hadoop.xml;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceMessages;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceParserResult;
import org.apache.knox.gateway.topology.simple.JSONProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfigurationParser;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorImpl;

public class HadoopXmlResourceParser {
    private static final HadoopXmlResourceMessages log = (HadoopXmlResourceMessages)MessagesFactory.get(HadoopXmlResourceMessages.class);
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_PREFIX = "providerConfigs:";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX = "role=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX = "name=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX = "enabled=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX = "param.";
    private static final String CONFIG_NAME_DISCOVERY_TYPE = "discoveryType";
    private static final String CONFIG_NAME_DISCOVERY_ADDRESS = "discoveryAddress";
    private static final String CONFIG_NAME_DISCOVERY_USER = "discoveryUser";
    private static final String CONFIG_NAME_DISCOVERY_PASSWORD_ALIAS = "discoveryPasswordAlias";
    private static final String CONFIG_NAME_DISCOVERY_CLUSTER = "cluster";
    private static final String CONFIG_NAME_PROVIDER_CONFIG_REFERENCE = "providerConfigRef";
    private static final String CONFIG_NAME_PROVISION_ENCRYPT_QUERY_STRING_CREDENTIAL = "provisionEncryptQueryStringCredential";
    private static final String CONFIG_NAME_APPLICATION_PREFIX = "app";
    private static final String CONFIG_NAME_SERVICE_URL = "url";
    private static final String CONFIG_NAME_SERVICE_VERSION = "version";
    private static final String CONFIG_NAME_SERVICES = "services";
    private static final String REMOVE = "remove";
    private final String sharedProvidersDir;
    private final GatewayConfig gatewayConfig;

    public HadoopXmlResourceParser(GatewayConfig gatewayConfig) {
        this.gatewayConfig = gatewayConfig;
        this.sharedProvidersDir = gatewayConfig.getGatewayProvidersConfigDir();
    }

    public HadoopXmlResourceParserResult parse(String path) {
        try {
            log.parseHadoopXmlResource(path);
            Configuration xmlConfiguration = new Configuration(false);
            xmlConfiguration.addResource(Paths.get(path, new String[0]).toUri().toURL());
            xmlConfiguration.reloadConfiguration();
            HadoopXmlResourceParserResult parserResult = this.parseXmlConfig(xmlConfiguration);
            this.logParserResult(path, parserResult);
            return parserResult;
        }
        catch (Exception e) {
            log.failedToParseXmlConfiguration(path, e.getMessage(), e);
            return new HadoopXmlResourceParserResult();
        }
    }

    private void logParserResult(String path, HadoopXmlResourceParserResult parserResult) {
        if (!parserResult.getDescriptors().isEmpty()) {
            log.foundKnoxDescriptors(String.join((CharSequence)", ", parserResult.getDescriptors().stream().map(SimpleDescriptor::getName).collect(Collectors.toSet())), path);
        }
        if (!parserResult.getProviders().isEmpty()) {
            log.foundKnoxProviderConfigurations(String.join((CharSequence)", ", new HashSet<String>(parserResult.getProviders().keySet())), path);
        }
        if (!parserResult.getDeletedDescriptors().isEmpty()) {
            log.foundKnoxDeletedDescriptors(String.join((CharSequence)", ", parserResult.getDeletedDescriptors()), path);
        }
        if (!parserResult.getDeletedProviders().isEmpty()) {
            log.foundKnoxDeletedProviderConfigurations(String.join((CharSequence)", ", parserResult.getDeletedProviders()), path);
        }
    }

    private HadoopXmlResourceParserResult parseXmlConfig(Configuration xmlConfiguration) {
        LinkedHashMap<String, ProviderConfiguration> providers = new LinkedHashMap<String, ProviderConfiguration>();
        LinkedHashSet<SimpleDescriptor> descriptors = new LinkedHashSet<SimpleDescriptor>();
        HashSet<String> deletedDescriptors = new HashSet<String>();
        HashSet<String> deletedProviders = new HashSet<String>();
        xmlConfiguration.forEach(xmlDescriptor -> {
            String xmlConfigurationKey = (String)xmlDescriptor.getKey();
            if (xmlConfigurationKey.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_PREFIX)) {
                String[] providerConfigurations = xmlConfigurationKey.replace(CONFIG_NAME_PROVIDER_CONFIGS_PREFIX, "").split(",");
                Arrays.stream(providerConfigurations).map(String::trim).forEach(providerConfigurationName -> this.parseProvider((String)providerConfigurationName, (String)xmlDescriptor.getValue(), providers, deletedProviders));
            } else {
                this.parseDescriptor(xmlConfigurationKey, (String)xmlDescriptor.getValue(), descriptors, deletedDescriptors);
            }
        });
        return new HadoopXmlResourceParserResult(providers, descriptors, deletedDescriptors, deletedProviders);
    }

    private void parseProvider(String providerConfigurationName, String value, Map<String, ProviderConfiguration> providers, Set<String> deletedProviders) {
        if (this.gatewayConfig.getReadOnlyOverrideProviderNames().contains(providerConfigurationName)) {
            log.skipReadOnlyProvider(providerConfigurationName);
            return;
        }
        File providerConfigFile = this.resolveProviderConfiguration(providerConfigurationName);
        try {
            ProviderConfiguration providerConfiguration = this.getProviderConfiguration(providers, providerConfigFile, providerConfigurationName);
            providerConfiguration.setReadOnly(true);
            if (this.isRemoved(value)) {
                deletedProviders.add(providerConfigurationName);
            } else {
                providerConfiguration.saveOrUpdateProviders(this.parseProviderConfigurations(value, providerConfiguration));
                providers.put(providerConfigurationName, providerConfiguration);
            }
        }
        catch (Exception e) {
            log.failedToParseProviderConfiguration(providerConfigurationName, e.getMessage(), e);
        }
    }

    private void parseDescriptor(String topologyName, String value, Set<SimpleDescriptor> descriptors, Set<String> deletedDescriptors) {
        if (this.gatewayConfig.getReadOnlyOverrideTopologyNames().contains(topologyName)) {
            log.skipReadOnlyDescriptor(topologyName);
            return;
        }
        if (this.isRemoved(value)) {
            deletedDescriptors.add(topologyName);
        } else {
            SimpleDescriptor descriptor = this.parseXmlDescriptor(topologyName, value);
            if (descriptor != null) {
                descriptors.add(descriptor);
            }
        }
    }

    private boolean isRemoved(String value) {
        return value.trim().equalsIgnoreCase(REMOVE);
    }

    private ProviderConfiguration getProviderConfiguration(Map<String, ProviderConfiguration> providers, File providerConfigFile, String providerConfigName) throws Exception {
        if (providers.containsKey(providerConfigName)) {
            return providers.get(providerConfigName);
        }
        return providerConfigFile == null ? new JSONProviderConfiguration() : ProviderConfigurationParser.parse((File)providerConfigFile);
    }

    private File resolveProviderConfiguration(String providerConfigurationName) {
        for (String supportedExtension : ProviderConfigurationParser.SUPPORTED_EXTENSIONS) {
            File providerConfigFile = new File(this.sharedProvidersDir, providerConfigurationName + "." + supportedExtension);
            if (!providerConfigFile.exists()) continue;
            return providerConfigFile;
        }
        return null;
    }

    private Set<ProviderConfiguration.Provider> parseProviderConfigurations(String xmlValue, ProviderConfiguration providerConfiguration) {
        LinkedHashSet<ProviderConfiguration.Provider> providers = new LinkedHashSet<ProviderConfiguration.Provider>();
        List<String> configurationPairs = Arrays.asList(xmlValue.split("#"));
        Set roles = configurationPairs.stream().filter(configurationPair -> configurationPair.trim().startsWith(CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX)).map(configurationPair -> configurationPair.replace(CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX, "").trim()).collect(Collectors.toSet());
        for (String role : roles) {
            providers.add(this.parseProvider(configurationPairs, role, providerConfiguration));
        }
        return providers;
    }

    private ProviderConfiguration.Provider parseProvider(List<String> configurationPairs, String role, ProviderConfiguration providerConfiguration) {
        JSONProviderConfiguration.JSONProvider provider = new JSONProviderConfiguration.JSONProvider();
        provider.setRole(role);
        this.getParamsForRole(role, providerConfiguration).forEach((arg_0, arg_1) -> ((JSONProviderConfiguration.JSONProvider)provider).addParam(arg_0, arg_1));
        provider.setEnabled(true);
        Set roleConfigurations = configurationPairs.stream().filter(configurationPair -> configurationPair.trim().startsWith(role)).map(configurationPair -> configurationPair.replace(role + ".", "").trim()).collect(Collectors.toSet());
        for (String roleConfiguration : roleConfigurations) {
            if (roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX)) {
                String[] paramKeyValue = roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX, "").split("=", 2);
                if (REMOVE.equals(paramKeyValue[0])) {
                    provider.removeParam(paramKeyValue[1]);
                    continue;
                }
                provider.addParam(paramKeyValue[0], paramKeyValue[1]);
                continue;
            }
            if (roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX)) {
                provider.setName(roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX, ""));
                continue;
            }
            if (roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX)) {
                provider.setEnabled(Boolean.valueOf(roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX, "")).booleanValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid role configuration: " + roleConfiguration + " in provider: " + provider.getName());
        }
        return provider;
    }

    private Map<String, String> getParamsForRole(String role, ProviderConfiguration providerConfiguration) {
        Optional<ProviderConfiguration.Provider> provider = providerConfiguration.getProviders().stream().filter(p -> p.getRole().equals(role)).findFirst();
        return provider.isPresent() ? provider.get().getParams() : new TreeMap();
    }

    private SimpleDescriptor parseXmlDescriptor(String name, String xmlValue) {
        try {
            String[] configurationPairs;
            SimpleDescriptorImpl descriptor = new SimpleDescriptorImpl();
            descriptor.setReadOnly(true);
            descriptor.setName(name);
            block22: for (String configurationPair : configurationPairs = xmlValue.split("#")) {
                String parameterName;
                String[] parameterPairParts = configurationPair.trim().split("=", 2);
                switch (parameterName = parameterPairParts[0].trim()) {
                    case "discoveryType": {
                        descriptor.setDiscoveryType(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "discoveryAddress": {
                        descriptor.setDiscoveryAddress(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "discoveryUser": {
                        descriptor.setDiscoveryUser(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "discoveryPasswordAlias": {
                        descriptor.setDiscoveryPasswordAlias(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "cluster": {
                        descriptor.setCluster(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "providerConfigRef": {
                        descriptor.setProviderConfig(parameterPairParts[1].trim());
                        continue block22;
                    }
                    case "provisionEncryptQueryStringCredential": {
                        descriptor.setProvisionEncryptQueryStringCredential(Boolean.valueOf(parameterPairParts[1].trim()).booleanValue());
                        continue block22;
                    }
                    case "services": {
                        Arrays.asList(parameterPairParts[1].trim().split(",", -1)).forEach(serviceName -> descriptor.addService((SimpleDescriptor.Service)this.emptyService((String)serviceName)));
                        continue block22;
                    }
                    default: {
                        if (parameterName.startsWith(CONFIG_NAME_APPLICATION_PREFIX)) {
                            this.parseApplication(descriptor, configurationPair.trim());
                            continue block22;
                        }
                        this.parseService(descriptor, configurationPair.trim());
                    }
                }
            }
            return descriptor;
        }
        catch (Exception e) {
            log.failedToParseDescriptor(name, e.getMessage(), e);
            return null;
        }
    }

    private SimpleDescriptorImpl.ServiceImpl emptyService(String serviceName) {
        SimpleDescriptorImpl.ServiceImpl service = new SimpleDescriptorImpl.ServiceImpl();
        service.setName(serviceName.trim().toUpperCase(Locale.ROOT));
        return service;
    }

    private void parseApplication(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] applicationParts = configurationPair.split(":");
        String applicationName = applicationParts[1].trim();
        SimpleDescriptorImpl.ApplicationImpl application = (SimpleDescriptorImpl.ApplicationImpl)descriptor.getApplication(applicationName);
        if (application == null) {
            application = new SimpleDescriptorImpl.ApplicationImpl();
            descriptor.addApplication((SimpleDescriptor.Application)application);
            application.setName(applicationParts[1]);
        }
        if (applicationParts.length > 2) {
            String applicationParameters = configurationPair.substring(applicationName.length() + 5);
            String[] applicationParameterParts = applicationParameters.split("=", 2);
            application.addParam(applicationParameterParts[0], applicationParameterParts[1]);
        }
    }

    private void parseService(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] serviceParts = configurationPair.split(":");
        String serviceName = serviceParts[0].trim();
        SimpleDescriptorImpl.ServiceImpl service = (SimpleDescriptorImpl.ServiceImpl)descriptor.getService(serviceName);
        if (service == null) {
            service = this.emptyService(serviceName);
            descriptor.addService((SimpleDescriptor.Service)service);
        }
        if (serviceParts.length > 1) {
            String serviceConfiguration = configurationPair.substring(serviceName.length() + 1).trim();
            String[] serviceConfigurationParts = serviceConfiguration.split("=", 2);
            String serviceConfigurationName = serviceConfigurationParts[0].trim();
            String serviceConfigurationValue = serviceConfigurationParts[1].trim();
            switch (serviceConfigurationName) {
                case "url": {
                    service.addUrl(serviceConfigurationValue);
                    break;
                }
                case "version": {
                    service.setVersion(serviceConfigurationValue);
                    break;
                }
                default: {
                    service.addParam(serviceConfigurationName, serviceConfigurationValue);
                }
            }
        }
    }
}

