/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import io.takari.maven.builder.smart.DependencyGraph;
import io.takari.maven.builder.smart.ProjectComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;

class ReactorBuildStats {
    private long startTime;
    private long stopTime;
    private final Map<String, AtomicLong> serviceTimes;
    private final Map<String, AtomicLong> bottleneckTimes;

    private ReactorBuildStats(Map<String, AtomicLong> serviceTimes, Map<String, AtomicLong> bottleneckTimes) {
        this.serviceTimes = Collections.unmodifiableMap(serviceTimes);
        this.bottleneckTimes = Collections.unmodifiableMap(bottleneckTimes);
    }

    private static String projectGAV(MavenProject project) {
        return String.valueOf(project.getGroupId()) + ":" + project.getArtifactId() + ":" + project.getVersion();
    }

    public static ReactorBuildStats create(Collection<MavenProject> projects) {
        HashMap<String, AtomicLong> serviceTimes = new HashMap<String, AtomicLong>();
        HashMap<String, AtomicLong> bottleneckTimes = new HashMap<String, AtomicLong>();
        projects.stream().map(ReactorBuildStats::projectGAV).forEach(key -> {
            serviceTimes.put((String)key, new AtomicLong());
            bottleneckTimes.put((String)key, new AtomicLong());
        });
        return new ReactorBuildStats(serviceTimes, bottleneckTimes);
    }

    public void recordStart() {
        this.startTime = System.nanoTime();
    }

    public void recordStop() {
        this.stopTime = System.nanoTime();
    }

    public void recordServiceTime(MavenProject project, long durationNanos) {
        AtomicLong serviceTime = this.serviceTimes.get(ReactorBuildStats.projectGAV(project));
        if (serviceTime == null) {
            throw new IllegalStateException("Unknown project " + ReactorBuildStats.projectGAV(project) + ", found " + this.serviceTimes.keySet());
        }
        serviceTime.addAndGet(durationNanos);
    }

    public void recordBottlenecks(Set<MavenProject> projects, int degreeOfConcurrency, long durationNanos) {
        if (projects.size() == 1) {
            projects.forEach(p -> {
                long l2 = this.bottleneckTimes.get(ReactorBuildStats.projectGAV(p)).addAndGet(durationNanos);
            });
        }
    }

    public long totalServiceTime(TimeUnit unit) {
        long nanos = this.serviceTimes.values().stream().mapToLong(AtomicLong::longValue).sum();
        return unit.convert(nanos, TimeUnit.NANOSECONDS);
    }

    public long walltimeTime(TimeUnit unit) {
        return unit.convert(this.stopTime - this.startTime, TimeUnit.NANOSECONDS);
    }

    public String renderCriticalPath(DependencyGraph<MavenProject> graph) {
        return this.renderCriticalPath(graph, ReactorBuildStats::projectGAV);
    }

    public <K> String renderCriticalPath(DependencyGraph<K> graph, Function<K, String> toKey) {
        StringBuilder result = new StringBuilder();
        long criticalPathServiceTime = 0L;
        result.append("Build critical path service times (and bottleneck** times):");
        for (K project : this.calculateCriticalPath(graph, toKey)) {
            result.append('\n');
            String key = toKey.apply(project);
            criticalPathServiceTime += this.serviceTimes.get(key).get();
            this.appendProjectTimes(result, key);
        }
        result.append(String.format("\nBuild critical path total service time %s", this.formatDuration(criticalPathServiceTime)));
        List<String> bottleneckProjects = this.getBottleneckProjects();
        if (!bottleneckProjects.isEmpty()) {
            long bottleneckTotalTime = 0L;
            result.append("\nBuild bottleneck projects service times (and bottleneck** times):");
            for (String bottleneck : bottleneckProjects) {
                result.append('\n');
                bottleneckTotalTime += this.bottleneckTimes.get(bottleneck).get();
                this.appendProjectTimes(result, bottleneck);
            }
            result.append(String.format("\nBuild bottlenecks total time %s", this.formatDuration(bottleneckTotalTime)));
        }
        result.append("\n** Bottlenecks are projects that limit build concurrency");
        result.append("\n   removing bottlenecks improves overall build time");
        return result.toString();
    }

    private void appendProjectTimes(StringBuilder result, String project) {
        long serviceTime = this.serviceTimes.get(project).get();
        long bottleneckTime = this.bottleneckTimes.get(project).get();
        result.append(String.format("   %-60s %s", project, this.formatDuration(serviceTime)));
        if (bottleneckTime > 0L) {
            result.append(String.format(" (%s)", this.formatDuration(bottleneckTime)));
        }
    }

    public List<String> getBottleneckProjects() {
        Comparator comparator = (a, b) -> {
            long ta = this.bottleneckTimes.get(a).longValue();
            long tb = this.bottleneckTimes.get(b).longValue();
            if (tb > ta) {
                return 1;
            }
            if (tb < ta) {
                return -1;
            }
            return 0;
        };
        return this.bottleneckTimes.keySet().stream().sorted(comparator).filter(project -> this.bottleneckTimes.get(project).get() > 0L).collect(Collectors.toList());
    }

    private String formatDuration(long nanos) {
        long secs = TimeUnit.NANOSECONDS.toSeconds(nanos);
        return String.format("%5d s", secs);
    }

    private <K> List<K> calculateCriticalPath(DependencyGraph<K> graph, Function<K, String> toKey) {
        Comparator<K> comparator = ProjectComparator.create0(graph, this.serviceTimes, toKey);
        Stream<Object> rootProjects = graph.getProjects().filter(graph::isRoot);
        ArrayList<Object> criticalPath = new ArrayList<Object>();
        Object project = this.getCriticalProject(rootProjects, comparator);
        do {
            criticalPath.add(project);
        } while ((project = this.getCriticalProject(graph.getDownstreamProjects(project), comparator)) != null);
        return criticalPath;
    }

    private <K> K getCriticalProject(Stream<K> projects, Comparator<K> comparator) {
        return projects.min(comparator).orElse(null);
    }
}

