/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.List;
import org.apache.nifi.parameter.EscapedParameterReference;
import org.apache.nifi.parameter.ParameterParser;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.StandardParameterReference;
import org.apache.nifi.parameter.StartCharacterEscape;

public abstract class AbstractParameterParser
implements ParameterParser {
    protected static final char START_TAG = '#';
    protected static final char OPEN_BRACE = '{';
    protected static final char CLOSE_BRACE = '}';

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ParameterToken parseParameterToken(String input, int startIndex, int sequentialStartTags, List<ParameterToken> tokens) {
        void var10_16;
        void var10_11;
        int startCharIndex = startIndex - sequentialStartTags;
        int endCharIndex = input.indexOf(125, startIndex);
        if (endCharIndex < 0) {
            return null;
        }
        int numEscapedStartTags = (sequentialStartTags - 1) / 2;
        int startOffset = startCharIndex + numEscapedStartTags * 2;
        String referenceText = input.substring(startOffset, endCharIndex + 1);
        boolean bl = false;
        while (var10_11 < numEscapedStartTags) {
            tokens.add(new StartCharacterEscape(startCharIndex + var10_11 * 2));
            ++var10_11;
        }
        if (sequentialStartTags % 2 == 1) {
            String parameterName = input.substring(startCharIndex + sequentialStartTags + 1, endCharIndex);
            if (parameterName.contains("'")) {
                if (!parameterName.startsWith("'") || !parameterName.endsWith("'")) return null;
                String parameterNameWithoutQuotes = parameterName.substring(1, parameterName.length() - 1);
                if (parameterNameWithoutQuotes.contains("'")) {
                    return null;
                }
                StandardParameterReference standardParameterReference = new StandardParameterReference(parameterNameWithoutQuotes, startOffset, endCharIndex, referenceText);
            } else {
                StandardParameterReference standardParameterReference = new StandardParameterReference(parameterName, startOffset, endCharIndex, referenceText);
            }
        } else {
            EscapedParameterReference escapedParameterReference = new EscapedParameterReference(startOffset, endCharIndex, referenceText);
        }
        tokens.add((ParameterToken)var10_16);
        return var10_16;
    }
}

