/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.nar;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.minifi.nar.NarAutoUnloadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoUnloaderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoUnloaderTask.class);
    private static final long POLL_INTERVAL_MS = 5000L;
    private final Path autoLoadPath;
    private final WatchService watchService;
    private final NarAutoUnloadService narAutoUnloadService;
    private volatile boolean stopped = false;

    public NarAutoUnloaderTask(Path autoLoadPath, WatchService watchService, NarAutoUnloadService narAutoUnloadService) {
        this.autoLoadPath = Objects.requireNonNull(autoLoadPath);
        this.watchService = Objects.requireNonNull(watchService);
        this.narAutoUnloadService = Objects.requireNonNull(narAutoUnloadService);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                WatchKey key;
                try {
                    LOGGER.debug("Polling for removed NARs at {}", (Object)this.autoLoadPath);
                    key = this.watchService.poll(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    LOGGER.info("WatchService interrupted, returning...");
                    return;
                }
                if (key == null) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.narAutoUnloadService.unloadNarFile(this.getFileName(event));
                }
                if (key.reset()) continue;
                LOGGER.error("NAR auto-load directory is no longer valid");
                this.stop();
            }
            catch (Throwable t) {
                LOGGER.error("Error un-loading NARs", t);
            }
        }
    }

    public void stop() {
        LOGGER.info("Stopping NAR Auto-Unloader");
        this.stopped = true;
    }

    public Path getAutoLoadPath() {
        return this.autoLoadPath;
    }

    private String getFileName(WatchEvent<?> event) {
        WatchEvent<?> ev = event;
        Path filename = (Path)ev.context();
        Path autoUnLoadFile = this.autoLoadPath.resolve(filename);
        return autoUnLoadFile.toFile().getName().toLowerCase();
    }
}

