/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.http.HttpClientRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.transport.rest.client.RestClientDecoder;
import org.apache.servicecomb.transport.rest.client.RestClientEncoder;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestClientCodecFilter
implements ConsumerFilter {
    public static final String NAME = "rest-client-codec";
    protected RestClientTransportContextFactory transportContextFactory;
    protected RestClientEncoder encoder;
    protected RestClientDecoder decoder;

    @Nonnull
    public String getName() {
        return NAME;
    }

    @Autowired
    public RestClientCodecFilter setTransportContextFactory(RestClientTransportContextFactory transportContextFactory) {
        this.transportContextFactory = transportContextFactory;
        return this;
    }

    @Autowired
    public RestClientCodecFilter setEncoder(RestClientEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    @Autowired
    public RestClientCodecFilter setDecoder(RestClientDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        invocation.getInvocationStageTrace().startGetConnection();
        this.startClientFiltersRequest(invocation);
        CompletionStage<HttpClientRequest> createRequest = this.transportContextFactory.createHttpClientRequest(invocation).toCompletionStage().whenComplete((c, e) -> invocation.getInvocationStageTrace().finishGetConnection());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(v -> createRequest)).thenAccept(httpClientRequest -> this.prepareTransportContext(invocation, (HttpClientRequest)httpClientRequest))).thenAccept(v -> invocation.onStartSendRequest())).thenAccept(v -> this.encoder.encode(invocation))).thenCompose(v -> nextNode.onFilter(invocation))).thenApply(response -> this.decoder.decode(invocation, (Response)response))).whenComplete((response, throwable) -> this.finishClientFiltersResponse(invocation));
    }

    protected void startClientFiltersRequest(Invocation invocation) {
        invocation.getInvocationStageTrace().startClientFiltersRequest();
    }

    protected void prepareTransportContext(Invocation invocation, HttpClientRequest httpClientRequest) {
        this.copyExtraHttpHeaders(invocation, httpClientRequest);
        RestClientTransportContext transportContext = this.transportContextFactory.create(invocation, httpClientRequest);
        invocation.setTransportContext((TransportContext)transportContext);
    }

    protected void copyExtraHttpHeaders(Invocation invocation, HttpClientRequest httpClientRequest) {
        Map httpHeaders = (Map)invocation.getHandlerContext().get("servicecomb-rest-consumer-header");
        if (httpHeaders == null) {
            return;
        }
        httpHeaders.forEach((key, value) -> {
            if ("Content-Length".equalsIgnoreCase((String)key)) {
                return;
            }
            if (null != value) {
                httpClientRequest.putHeader(key, value);
            }
        });
    }

    protected void finishClientFiltersResponse(Invocation invocation) {
        invocation.getInvocationStageTrace().finishClientFiltersResponse();
    }
}

