/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.internal.shared.BandAggregateArgument;
import org.apache.sis.image.BandAggregateLayout;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.BandSharedRaster;
import org.apache.sis.image.BandSharing;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.MultiSourceImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArraysExt;

class BandAggregateImage
extends MultiSourceImage {
    private final boolean allowSharing;
    private final List<SampleDimension> sampleDimensions;

    static void unwrap(BandAggregateArgument.Unwrapper unwrapper) {
        RenderedImage source = (RenderedImage)unwrapper.source;
        int[] bands = unwrapper.bands;
        while (source instanceof ImageAdapter) {
            source = ((ImageAdapter)source).source;
        }
        if (source instanceof BandSelectImage) {
            BandSelectImage select = (BandSelectImage)source;
            bands = select.getSourceBands(bands);
            source = select.getSource();
        }
        if (source instanceof BandAggregateImage) {
            ((BandAggregateImage)source).subset(bands, null, unwrapper);
        } else if (source != unwrapper.source) {
            unwrapper.apply(new RenderedImage[]{source}, new int[][]{bands});
        }
    }

    final RenderedImage subset(int[] bands, ColorModel colors, BandAggregateArgument.Unwrapper unwrapper) {
        RenderedImage[] sources = new RenderedImage[bands.length];
        int[][] bandsPerSource = new int[bands.length][];
        int lower = 0;
        int upper = 0;
        int sourceIndex = -1;
        RenderedImage source = null;
        for (int i = 0; i < bands.length; ++i) {
            int band = bands[i];
            if (band < lower) {
                upper = 0;
                lower = 0;
                sourceIndex = -1;
            }
            while (band >= upper) {
                source = this.getSource(++sourceIndex);
                lower = upper;
                upper += ImageUtilities.getNumBands(source);
            }
            sources[i] = source;
            bandsPerSource[i] = new int[]{band - lower};
        }
        if (unwrapper != null) {
            unwrapper.apply(sources, bandsPerSource);
            return null;
        }
        return BandAggregateImage.create(sources, bandsPerSource, colors != null ? Colorizer.forInstance(colors) : null, false, this.allowSharing, this.parallel);
    }

    static RenderedImage create(RenderedImage[] sources, int[][] bandsPerSource, Colorizer colorizer, boolean forceColors, boolean allowSharing, boolean parallel) {
        BandAggregateLayout layout = new BandAggregateLayout(sources, bandsPerSource, allowSharing);
        BandAggregateImage image = layout.isWritable() ? new Writable(layout, colorizer, parallel) : new BandAggregateImage(layout, colorizer, parallel);
        RenderedImage result = image;
        if (image.getNumSources() == 1) {
            result = image.getSource();
            if (forceColors && colorizer != null) {
                result = RecoloredImage.applySameColors(result, image);
            }
        } else {
            result = ImageProcessor.unique(result);
        }
        return BandSelectImage.create(result, false, layout.bandSelect);
    }

    private BandAggregateImage(BandAggregateLayout layout, Colorizer colorizer, boolean parallel) {
        super(layout.filteredSources, layout.domain, layout.minTile, layout.sampleModel, layout.createColorModel(colorizer), parallel);
        this.allowSharing = layout.allowSharing;
        this.sampleDimensions = layout.sampleDimensions;
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) {
        BandSharing sharing;
        if (tile instanceof BandSharedRaster) {
            tile = null;
        }
        BandSharedRaster shared = null;
        if (this.allowSharing && (sharing = BandSharing.create((BandedSampleModel)this.sampleModel)) != null) {
            shared = sharing.createRaster(this.tileToPixel(tileX, tileY), this.getSourceArray());
            tile = shared;
        }
        if (tile == null) {
            tile = this.createTile(tileX, tileY);
        }
        int band = 0;
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            RenderedImage source = this.getSource(i);
            int numBands = ImageUtilities.getNumBands(source);
            if (shared == null || shared.needCopy(i)) {
                Rectangle aoi = tile.getBounds();
                ImageUtilities.clipBounds(source, aoi);
                if (!aoi.isEmpty()) {
                    int[] bands = ArraysExt.range((int)band, (int)(band + numBands));
                    WritableRaster target = tile.createWritableChild(aoi.x, aoi.y, aoi.width, aoi.height, aoi.x, aoi.y, bands);
                    BandAggregateImage.copyData(aoi, source, target);
                }
            }
            band += numBands;
        }
        return tile;
    }

    @Override
    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this.sampleDimensions != null) {
            names.add("org.apache.sis.SampleDimensions");
        }
        int numSources = this.getNumSources();
        for (int i = 0; i < numSources; ++i) {
            String[] more = this.getSource(i).getPropertyNames();
            if (more == null) continue;
            names.addAll(Arrays.asList(more));
        }
        names.retainAll(BandSelectImage.REDUCED_PROPERTIES);
        return names.isEmpty() ? null : (String[])names.toArray(String[]::new);
    }

    @Override
    public Object getProperty(String key) {
        Object[] result;
        int numBands = this.sampleModel.getNumBands();
        switch (key) {
            case "org.apache.sis.SampleDimensions": {
                if (this.sampleDimensions != null) {
                    return this.sampleDimensions.toArray(SampleDimension[]::new);
                }
                result = new SampleDimension[numBands];
                break;
            }
            case "org.apache.sis.Statistics": {
                result = new Statistics[numBands];
                break;
            }
            case "org.apache.sis.SampleResolutions": {
                double[] r = new double[numBands];
                Arrays.fill(r, Double.NaN);
                result = r;
                break;
            }
            default: {
                return super.getProperty(key);
            }
        }
        int offset = 0;
        boolean found = false;
        int numSources = this.getNumSources();
        for (int i = 0; i < numSources; ++i) {
            RenderedImage source = this.getSource(i);
            int n = ImageUtilities.getNumBands(source);
            Object value = source.getProperty(key);
            if (result.getClass().isInstance(value)) {
                System.arraycopy(value, 0, result, offset, n);
                found = true;
            }
            offset += n;
        }
        return found ? result : null;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            BandAggregateImage that = (BandAggregateImage)object;
            return that.allowSharing == this.allowSharing && Objects.equals(that.sampleDimensions, this.sampleDimensions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.allowSharing) + Objects.hashCode(this.sampleDimensions);
    }

    private static final class Writable
    extends BandAggregateImage
    implements WritableRenderedImage {
        Writable(BandAggregateLayout layout, Colorizer colorizer, boolean parallel) {
            super(layout, colorizer, parallel);
        }

        @Override
        public WritableRaster getWritableTile(int tileX, int tileY) {
            WritableRaster tile = (WritableRaster)this.getTile(tileX, tileY);
            if (tile instanceof BandSharedRaster) {
                ((BandSharedRaster)tile).acquireWritableTiles(this.getSourceArray());
            }
            try {
                this.markTileWritable(tileX, tileY, true);
            }
            catch (RuntimeException e) {
                if (tile instanceof BandSharedRaster) {
                    ((BandSharedRaster)tile).releaseWritableTiles(e);
                }
                throw e;
            }
            return tile;
        }

        @Override
        public void releaseWritableTile(int tileX, int tileY) {
            if (this.markTileWritable(tileX, tileY, false)) {
                Raster tile = this.getTile(tileX, tileY);
                if (tile instanceof BandSharedRaster) {
                    ((BandSharedRaster)tile).releaseWritableTiles(null);
                }
                this.setData(tile);
            }
        }

        @Override
        public void setData(Raster tile) {
            BandSharedRaster shared = tile instanceof BandSharedRaster ? (BandSharedRaster)tile : null;
            int band = 0;
            int n = this.getNumSources();
            for (int i = 0; i < n; ++i) {
                WritableRenderedImage target = (WritableRenderedImage)this.getSource(i);
                int numBands = ImageUtilities.getNumBands(target);
                if (shared == null || shared.needCopy(i)) {
                    Rectangle aoi = tile.getBounds();
                    ImageUtilities.clipBounds(target, aoi);
                    if (!aoi.isEmpty()) {
                        int[] bands = ArraysExt.range((int)band, (int)(band + numBands));
                        Raster source = tile.createChild(aoi.x, aoi.y, aoi.width, aoi.height, aoi.x, aoi.y, bands);
                        target.setData(source);
                    }
                }
                band += numBands;
            }
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    }
}

