/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

enum DataType {
    UNKNOWN(32, 0),
    UNSIGNED_BYTE(0, 8),
    UNSIGNED_SHORT(1, 16),
    SHORT(2, 16),
    UNSIGNED_INT(3, 32),
    INT(3, 32),
    FLOAT(4, 32),
    DOUBLE(5, 64),
    COMPLEX_SHORT(32, 32),
    COMPLEX_INT(32, 64),
    COMPLEX_FLOAT(32, 64),
    COMPLEX_DOUBLE(32, 128),
    UNSIGNED_LONG(32, 64),
    LONG(32, 64),
    BYTE(32, 8);

    final short imageType;
    final short numBits;
    private static final DataType[] VALUES;

    private DataType(short imageType, short numBits) {
        this.imageType = imageType;
        this.numBits = numBits;
    }

    public static DataType valueOf(int ordinal) {
        return ordinal >= 0 && ordinal < VALUES.length ? VALUES[ordinal] : UNKNOWN;
    }

    public DataType forDataBufferType(int type) {
        if (type == this.imageType) {
            return this;
        }
        switch (type) {
            case 0: {
                return UNSIGNED_BYTE;
            }
            case 1: {
                return UNSIGNED_SHORT;
            }
            case 2: {
                return SHORT;
            }
            case 3: {
                return INT;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
        }
        return UNKNOWN;
    }

    static {
        VALUES = DataType.values();
    }
}

