/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.sis.util.collection.CheckedArrayList;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.CloneAccess;

final class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedContainer<E>,
CloneAccess {
    private static final long serialVersionUID = 1999408533884863599L;
    private final Class<E> type;

    CheckedHashSet(Class<E> type) {
        this.type = type;
    }

    CheckedHashSet(Collection<? extends E> source, Class<E> type) {
        super(Containers.hashMapCapacity(source.size()));
        this.type = type;
        this.addAll(source);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    @Override
    public CheckedContainer.Mutability getMutability() {
        return CheckedContainer.Mutability.MODIFIABLE;
    }

    @Override
    public boolean add(E element) throws IllegalArgumentException {
        if (this.type.isInstance(element)) {
            return super.add(element);
        }
        String message = CheckedArrayList.illegalElement(this, element, this.type);
        if (message == null) {
            return false;
        }
        if (element == null) {
            throw new NullPointerException(message);
        }
        throw new IllegalArgumentException(message);
    }
}

