/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import jakarta.xml.bind.annotation.XmlTransient;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.StateChanger;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.collection.Containers;
import org.opengis.util.CodeList;

@XmlTransient
public abstract class ModifiableMetadata
extends AbstractMetadata {
    private static final byte EDITABLE = 0;
    private static final byte STAGED = 1;
    private static final byte FREEZING = 2;
    private static final byte COMPLETABLE = 3;
    private static final byte FINAL = 4;
    private transient byte state;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object source) {
        super(source);
    }

    public State state() {
        return State.VALUES[this.state];
    }

    public boolean transitionTo(State target) {
        if (target.code < this.state) {
            throw new UnmodifiableMetadataException(Resources.format((short)1));
        }
        if (target.code == this.state || this.state == 2) {
            return false;
        }
        byte result = this.state;
        try {
            this.state = (byte)2;
            StateChanger.applyTo(target, this);
            result = target.code;
        }
        finally {
            this.state = result;
        }
        return true;
    }

    public ModifiableMetadata deepCopy(State target) {
        MetadataCopier copier;
        if (target.isUnmodifiable()) {
            if (this.state >= 4) {
                return this;
            }
            copier = MetadataCopier.forModifiable(this.getStandard());
        } else {
            copier = new MetadataCopier(this.getStandard());
        }
        ModifiableMetadata md = (ModifiableMetadata)copier.copyRecursively(this.getInterface(), this);
        if (target.code > 0) {
            md.transitionTo(target);
        }
        return md;
    }

    protected void checkWritePermission(Object current) throws UnmodifiableMetadataException {
        if (this.state != 3) {
            if (this.state == 4) {
                throw new UnmodifiableMetadataException(Resources.format((short)1));
            }
        } else if (current != null) {
            MetadataStandard standard = current instanceof AbstractMetadata ? ((AbstractMetadata)current).getStandard() : this.getStandard();
            Object c = standard.getTitle(current);
            if (c != null) {
                current = c;
            }
            throw new UnmodifiableMetadataException(Resources.format((short)2, current));
        }
    }

    protected final <E> List<E> writeList(Collection<? extends E> source, List<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return (List)this.write(source, target, elementType, false);
    }

    protected final <E> Set<E> writeSet(Collection<? extends E> source, Set<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return (Set)this.write(source, target, elementType, true);
    }

    protected final <E> Collection<E> writeCollection(Collection<? extends E> source, Collection<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return this.write(source, target, elementType, ModifiableMetadata.useSet(elementType));
    }

    private <E> Collection<E> write(Collection<? extends E> source, Collection<E> target, Class<E> elementType, boolean useSet) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.state == 2) {
                return source;
            }
            this.checkWritePermission(ImplementationHelper.valueIfDefined(target));
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null && this.state != 3) {
                    target.clear();
                    target.addAll(source);
                } else {
                    target = useSet ? Containers.newCheckedSet(source, elementType) : Containers.newCheckedList(source, elementType);
                }
                if (this.state == 3) {
                    target = useSet ? Containers.unmodifiable((Set)target) : Containers.unmodifiable((List)((List)target));
                }
            }
        }
        return target;
    }

    protected final <K, V> Map<K, V> writeMap(Map<? extends K, ? extends V> source, Map<K, V> target, Class<K> keyType) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.state == 2) {
                return source;
            }
            this.checkWritePermission(target == null || target.isEmpty() ? null : target);
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null && this.state != 3) {
                    target.clear();
                } else {
                    target = ModifiableMetadata.createMap(keyType, source);
                }
                target.putAll(source);
                if (this.state == 3) {
                    target = Containers.unmodifiable(target);
                }
            }
        }
        return target;
    }

    protected static <E> List<E> copyList(Collection<? extends E> source, Class<E> elementType) {
        return Containers.isNullOrEmpty(source) ? null : Containers.newCheckedList(source, elementType);
    }

    protected static <E> Set<E> copySet(Collection<? extends E> source, Class<E> elementType) {
        return Containers.isNullOrEmpty(source) ? null : Containers.newCheckedSet(source, elementType);
    }

    protected static <E> Collection<E> copyCollection(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        if (ModifiableMetadata.useSet(elementType)) {
            return Containers.newCheckedSet(source, elementType);
        }
        return Containers.newCheckedList(source, elementType);
    }

    protected static <K, V> Map<K, V> copyMap(Map<? extends K, ? extends V> source, Class<K> keyType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        Map<? extends K, ? extends V> target = ModifiableMetadata.createMap(keyType, source);
        target.putAll(source);
        return target;
    }

    protected static <E> Collection<E> singleton(E value, Class<E> elementType) {
        if (value == null) {
            return null;
        }
        Set<E> singleton = Collections.singleton(value);
        if (ModifiableMetadata.useSet(elementType)) {
            return Containers.newCheckedSet(singleton, elementType);
        }
        return Containers.newCheckedList(singleton, elementType);
    }

    private static boolean nullForEmptyCollection() {
        return Semaphores.NULL_FOR_EMPTY_COLLECTION.get();
    }

    protected final <E> List<E> nonNullList(List<E> current, Class<E> elementType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.nullForEmptyCollection() ? null : current;
        }
        if (ModifiableMetadata.nullForEmptyCollection()) {
            return null;
        }
        if (this.state < 2) {
            return Containers.newCheckedList(null, elementType);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> current, Class<E> elementType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.nullForEmptyCollection() ? null : current;
        }
        if (ModifiableMetadata.nullForEmptyCollection()) {
            return null;
        }
        if (this.state < 2) {
            return Containers.newCheckedSet(null, elementType);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> current, Class<E> elementType) {
        boolean isModifiable;
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.nullForEmptyCollection() ? null : current;
        }
        if (ModifiableMetadata.nullForEmptyCollection()) {
            return null;
        }
        boolean bl = isModifiable = this.state < 2;
        if (ModifiableMetadata.useSet(elementType)) {
            if (isModifiable) {
                return Containers.newCheckedSet(null, elementType);
            }
            return Collections.emptySet();
        }
        if (isModifiable) {
            return Containers.newCheckedList(null, elementType);
        }
        return Collections.emptyList();
    }

    protected final <K, V> Map<K, V> nonNullMap(Map<K, V> current, Class<K> keyType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.nullForEmptyCollection() ? null : current;
        }
        if (ModifiableMetadata.nullForEmptyCollection()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createMap(keyType, current);
        }
        return Collections.emptyMap();
    }

    private static <K, V> Map<K, V> createMap(Class<K> keyType, Map<?, ?> source) {
        if (Enum.class.isAssignableFrom(keyType)) {
            return new EnumMap(keyType);
        }
        return source != null ? JDK19.newLinkedHashMap((int)source.size()) : new LinkedHashMap(4);
    }

    private static boolean useSet(Class<?> elementType) {
        return CodeList.class.isAssignableFrom(elementType) || Enum.class.isAssignableFrom(elementType) || Charset.class.isAssignableFrom(elementType) || String.class == elementType || Locale.class == elementType || Currency.class == elementType;
    }

    public static enum State {
        EDITABLE(0),
        COMPLETABLE(3),
        FINAL(4);

        private static final State[] VALUES;
        final byte code;

        private State(byte code) {
            this.code = code;
        }

        final boolean isUnmodifiable() {
            return this.code >= 4;
        }

        static {
            VALUES = new State[5];
            State.VALUES[0] = EDITABLE;
            State.VALUES[1] = EDITABLE;
            State.VALUES[2] = FINAL;
            State.VALUES[3] = COMPLETABLE;
            State.VALUES[4] = FINAL;
        }
    }
}

