/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.engine.util.StyleResolver;

public class JRBaseStyle
implements JRStyle,
Serializable,
JRChangeEventsSupport,
Deduplicable {
    public static final String EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY = "engine.style.circular.dependency";
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BLANK_WHEN_NULL = "isBlankWhenNull";
    public static final String PROPERTY_BOLD = "isBold";
    public static final String PROPERTY_FILL = "fill";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FORECOLOR = "forecolor";
    public static final String PROPERTY_HORIZONTAL_TEXT_ALIGNMENT = "horizontalTextAlignment";
    public static final String PROPERTY_HORIZONTAL_IMAGE_ALIGNMENT = "horizontalImageAlignment";
    public static final String PROPERTY_ITALIC = "isItalic";
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_PDF_EMBEDDED = "isPdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_RADIUS = "radius";
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_SCALE_IMAGE = "scaleImage";
    public static final String PROPERTY_STRIKE_THROUGH = "isStrikeThrough";
    public static final String PROPERTY_MARKUP = "markup";
    public static final String PROPERTY_UNDERLINE = "isUnderline";
    public static final String PROPERTY_VERTICAL_TEXT_ALIGNMENT = "verticalTextAlignment";
    public static final String PROPERTY_VERTICAL_IMAGE_ALIGNMENT = "verticalImageAlignment";
    protected final JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    protected String parentStyleNameReference;
    protected String name;
    protected boolean isDefault;
    protected ModeEnum mode;
    protected Color forecolor;
    protected Color backcolor;
    protected JRPen linePen;
    protected FillEnum fill;
    protected Integer radius;
    protected ScaleImageEnum scaleImage;
    protected HorizontalTextAlignEnum horizontalTextAlign;
    protected VerticalTextAlignEnum verticalTextAlign;
    protected HorizontalImageAlignEnum horizontalImageAlign;
    protected VerticalImageAlignEnum verticalImageAlign;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Float fontSize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    protected RotationEnum rotation;
    protected String markup;
    protected String pattern;
    protected Boolean isBlankWhenNull;
    protected JRConditionalStyle[] conditionalStyles;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBaseStyle() {
        this((JRDefaultStyleProvider)null);
    }

    public JRBaseStyle(JRDefaultStyleProvider defaultStyleProvider) {
        this.defaultStyleProvider = defaultStyleProvider;
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
        this.paragraph = new JRBaseParagraph(this);
    }

    public JRBaseStyle(String name) {
        this((JRDefaultStyleProvider)null);
        this.name = name;
    }

    public JRBaseStyle(JRDefaultStyleProvider defaultStyleProvider, String name) {
        this(defaultStyleProvider);
        this.name = name;
    }

    public JRBaseStyle(JRStyle style, JRAbstractObjectFactory factory) {
        this.name = style.getName();
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        factory.setStyle(new JRStyleSetter(){

            @Override
            public void setStyle(JRStyle aStyle) {
                JRBaseStyle.this.setParentStyle(aStyle);
            }

            @Override
            public void setStyleNameReference(String name) {
                JRBaseStyle.this.parentStyleNameReference = name;
            }
        }, style);
        this.isDefault = style.isDefault();
        this.mode = style.getOwnMode();
        this.forecolor = style.getOwnForecolor();
        this.backcolor = style.getOwnBackcolor();
        this.linePen = style.getLinePen().clone(this);
        this.fill = style.getOwnFill();
        this.radius = style.getOwnRadius();
        this.scaleImage = style.getOwnScaleImage();
        this.horizontalTextAlign = style.getOwnHorizontalTextAlign();
        this.verticalTextAlign = style.getOwnVerticalTextAlign();
        this.horizontalImageAlign = style.getOwnHorizontalImageAlign();
        this.verticalImageAlign = style.getOwnVerticalImageAlign();
        this.lineBox = style.getLineBox().clone(this);
        this.paragraph = style.getParagraph().clone(this);
        this.rotation = style.getOwnRotation();
        this.markup = style.getOwnMarkup();
        this.pattern = style.getOwnPattern();
        this.fontName = style.getOwnFontName();
        this.isBold = style.isOwnBold();
        this.isItalic = style.isOwnItalic();
        this.isUnderline = style.isOwnUnderline();
        this.isStrikeThrough = style.isOwnStrikeThrough();
        this.fontSize = style.getOwnFontSize();
        this.pdfFontName = style.getOwnPdfFontName();
        this.pdfEncoding = style.getOwnPdfEncoding();
        this.isPdfEmbedded = style.isOwnPdfEmbedded();
        this.isBlankWhenNull = style.isOwnBlankWhenNull();
        JRConditionalStyle[] condStyles = style.getConditionalStyles();
        if (condStyles != null && condStyles.length > 0) {
            this.conditionalStyles = new JRConditionalStyle[condStyles.length];
            for (int i = 0; i < condStyles.length; ++i) {
                this.conditionalStyles[i] = factory.getConditionalStyle(condStyles[i], this);
            }
        }
    }

    protected void setParentStyle(JRStyle parentStyle) {
        this.parentStyle = parentStyle;
        this.checkCircularParent();
    }

    protected void checkCircularParent() {
        for (JRStyle ancestor = this.parentStyle; ancestor != null; ancestor = ancestor.getStyle()) {
            if (ancestor != this) continue;
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY, this.getName());
        }
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected StyleResolver getStyleResolver() {
        if (this.getDefaultStyleProvider() != null) {
            return this.getDefaultStyleProvider().getStyleResolver();
        }
        return StyleResolver.getInstance();
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public Color getForecolor() {
        return this.getStyleResolver().getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public Color getBackcolor() {
        return this.getStyleResolver().getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @JsonSetter
    private void setLinePen(JRPen linePen) {
        this.linePen = linePen.clone(this);
    }

    @Override
    public FillEnum getFill() {
        return this.getStyleResolver().getFill(this);
    }

    @Override
    public FillEnum getOwnFill() {
        return this.fill;
    }

    @Override
    public Integer getRadius() {
        return this.getStyleResolver().getRadius(this);
    }

    @Override
    public Integer getOwnRadius() {
        return this.radius;
    }

    @Override
    public ScaleImageEnum getScaleImage() {
        return this.getStyleResolver().getScaleImage(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public HorizontalTextAlignEnum getHorizontalTextAlign() {
        return this.getStyleResolver().getHorizontalTextAlign(this);
    }

    @Override
    public HorizontalTextAlignEnum getOwnHorizontalTextAlign() {
        return this.horizontalTextAlign;
    }

    @Override
    public VerticalTextAlignEnum getVerticalTextAlign() {
        return this.getStyleResolver().getVerticalTextAlign(this);
    }

    @Override
    public VerticalTextAlignEnum getOwnVerticalTextAlign() {
        return this.verticalTextAlign;
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @JsonSetter(value="box")
    private void setLineBox(JRLineBox lineBox) {
        this.lineBox = lineBox == null ? null : lineBox.clone(this);
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    @JsonSetter
    private void setParagraph(JRParagraph paragraph) {
        this.paragraph = paragraph;
    }

    @Override
    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation(this);
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, old, this.rotation);
    }

    @Override
    public String getMarkup() {
        return this.getStyleResolver().getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public Boolean isBlankWhenNull() {
        return this.getStyleResolver().isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public String getFontName() {
        return this.getStyleResolver().getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public Boolean isBold() {
        return this.getStyleResolver().isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public Boolean isItalic() {
        return this.getStyleResolver().isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public Boolean isUnderline() {
        return this.getStyleResolver().isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public Boolean isStrikeThrough() {
        return this.getStyleResolver().isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public Float getFontSize() {
        return this.getStyleResolver().getFontSize(this);
    }

    @Override
    public Float getOwnFontSize() {
        return this.fontSize;
    }

    @Override
    public String getPdfFontName() {
        return this.getStyleResolver().getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return this.getStyleResolver().getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public Boolean isPdfEmbedded() {
        return this.getStyleResolver().isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public String getPattern() {
        return this.getStyleResolver().getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getModeValue(this);
    }

    @Override
    public ModeEnum getOwnMode() {
        return this.mode;
    }

    @Override
    public void setForecolor(Color forecolor) {
        Color old = this.forecolor;
        this.forecolor = forecolor;
        this.getEventSupport().firePropertyChange(PROPERTY_FORECOLOR, old, this.forecolor);
    }

    @Override
    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    @Override
    public void setMode(ModeEnum mode) {
        ModeEnum old = this.mode;
        this.mode = mode;
        this.getEventSupport().firePropertyChange(PROPERTY_MODE, old, this.mode);
    }

    @Override
    public void setFill(FillEnum fill) {
        FillEnum old = this.fill;
        this.fill = fill;
        this.getEventSupport().firePropertyChange(PROPERTY_FILL, old, this.fill);
    }

    @Override
    public void setRadius(Integer radius) {
        Integer old = this.radius;
        this.radius = radius;
        this.getEventSupport().firePropertyChange(PROPERTY_RADIUS, old, this.radius);
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        ScaleImageEnum old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange(PROPERTY_SCALE_IMAGE, old, this.scaleImage);
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        HorizontalImageAlignEnum old = this.horizontalImageAlign;
        this.horizontalImageAlign = horizontalImageAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_IMAGE_ALIGNMENT, old, this.horizontalImageAlign);
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        VerticalImageAlignEnum old = this.verticalImageAlign;
        this.verticalImageAlign = verticalImageAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_IMAGE_ALIGNMENT, old, this.verticalImageAlign);
    }

    @Override
    public void setHorizontalTextAlign(HorizontalTextAlignEnum horizontalTextAlign) {
        HorizontalTextAlignEnum old = this.horizontalTextAlign;
        this.horizontalTextAlign = horizontalTextAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_TEXT_ALIGNMENT, old, this.horizontalTextAlign);
    }

    @Override
    public void setVerticalTextAlign(VerticalTextAlignEnum verticalTextAlign) {
        VerticalTextAlignEnum old = this.verticalTextAlign;
        this.verticalTextAlign = verticalTextAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_TEXT_ALIGNMENT, old, this.verticalTextAlign);
    }

    @Override
    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, old, this.fontName);
    }

    @Override
    public void setBold(Boolean bold) {
        Boolean old = this.isBold;
        this.isBold = bold;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, old, this.isBold);
    }

    @Override
    public void setItalic(Boolean italic) {
        Boolean old = this.isItalic;
        this.isItalic = italic;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, old, this.isItalic);
    }

    @Override
    public void setPdfEmbedded(Boolean pdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = pdfEmbedded;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, old, this.isPdfEmbedded);
    }

    @Override
    public void setStrikeThrough(Boolean strikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = strikeThrough;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, old, this.isStrikeThrough);
    }

    @Override
    public void setMarkup(String markup) {
        String old = this.markup;
        this.markup = markup;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKUP, old, this.markup);
    }

    @Override
    public void setBlankWhenNull(Boolean isBlankWhenNull) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlankWhenNull;
        this.getEventSupport().firePropertyChange(PROPERTY_BLANK_WHEN_NULL, old, this.isBlankWhenNull);
    }

    @Override
    public void setUnderline(Boolean underline) {
        Boolean old = this.isUnderline;
        this.isUnderline = underline;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, old, this.isUnderline);
    }

    @Override
    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN, old, this.pattern);
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, old, this.pdfEncoding);
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, old, this.pdfFontName);
    }

    @Override
    public void setFontSize(Float fontSize) {
        Float old = this.fontSize;
        this.fontSize = fontSize;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, old, this.fontSize);
    }

    @Override
    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStyles;
    }

    @Override
    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    @Override
    public Float getDefaultLineWidth() {
        return null;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseStyle jRBaseStyle = this;
        synchronized (jRBaseStyle) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        JRBaseStyle clone = null;
        try {
            clone = (JRBaseStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.lineBox = this.lineBox == null ? null : this.lineBox.clone(clone);
        clone.linePen = this.linePen == null ? null : this.linePen.clone(clone);
        clone.paragraph = this.paragraph == null ? null : this.paragraph.clone(clone);
        clone.conditionalStyles = (JRConditionalStyle[])JRCloneUtils.cloneArray((JRCloneable[])this.conditionalStyles);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        hash.addIdentity(this.parentStyle);
        this.addStyleHash(hash);
        hash.addIdentical(this.conditionalStyles);
        return hash.getHashCode();
    }

    protected void addStyleHash(ObjectUtils.HashCode hash) {
        hash.add(this.name);
        hash.add(this.isDefault);
        hash.add(this.mode);
        hash.add(this.forecolor);
        hash.add(this.backcolor);
        hash.addIdentical(this.linePen);
        hash.add(this.fill);
        hash.add(this.radius);
        hash.add(this.scaleImage);
        hash.add(this.horizontalTextAlign);
        hash.add(this.verticalTextAlign);
        hash.add(this.horizontalImageAlign);
        hash.add(this.verticalImageAlign);
        hash.addIdentical(this.lineBox);
        hash.addIdentical(this.paragraph);
        hash.add(this.fontName);
        hash.add(this.isBold);
        hash.add(this.isItalic);
        hash.add(this.isUnderline);
        hash.add(this.isStrikeThrough);
        hash.add(this.fontSize);
        hash.add(this.pdfFontName);
        hash.add(this.pdfEncoding);
        hash.add(this.isPdfEmbedded);
        hash.add(this.rotation);
        hash.add(this.markup);
        hash.add(this.pattern);
        hash.add(this.isBlankWhenNull);
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBaseStyle)) {
            return false;
        }
        JRBaseStyle style = (JRBaseStyle)object;
        return ObjectUtils.equalsIdentity(this.parentStyle, style.parentStyle) && this.identicalStyle(style) && ObjectUtils.identical(this.conditionalStyles, style.conditionalStyles);
    }

    protected boolean identicalStyle(JRBaseStyle style) {
        return ObjectUtils.equals(this.name, style.name) && ObjectUtils.equals(this.isDefault, style.isDefault) && ObjectUtils.equals(this.mode, style.mode) && ObjectUtils.equals(this.forecolor, style.forecolor) && ObjectUtils.equals(this.backcolor, style.backcolor) && ObjectUtils.identical(this.linePen, style.linePen) && ObjectUtils.equals(this.fill, style.fill) && ObjectUtils.equals(this.radius, style.radius) && ObjectUtils.equals(this.scaleImage, style.scaleImage) && ObjectUtils.equals(this.horizontalTextAlign, style.horizontalTextAlign) && ObjectUtils.equals(this.verticalTextAlign, style.verticalTextAlign) && ObjectUtils.equals(this.horizontalImageAlign, style.horizontalImageAlign) && ObjectUtils.equals(this.verticalImageAlign, style.verticalImageAlign) && ObjectUtils.identical(this.lineBox, style.lineBox) && ObjectUtils.identical(this.paragraph, style.paragraph) && ObjectUtils.equals(this.fontName, style.fontName) && ObjectUtils.equals(this.isBold, style.isBold) && ObjectUtils.equals(this.isItalic, style.isItalic) && ObjectUtils.equals(this.isUnderline, style.isUnderline) && ObjectUtils.equals(this.isStrikeThrough, style.isStrikeThrough) && ObjectUtils.equals(this.fontSize, style.fontSize) && ObjectUtils.equals(this.pdfFontName, style.pdfFontName) && ObjectUtils.equals(this.pdfEncoding, style.pdfEncoding) && ObjectUtils.equals(this.isPdfEmbedded, style.isPdfEmbedded) && ObjectUtils.equals(this.rotation, style.rotation) && ObjectUtils.equals(this.markup, style.markup) && ObjectUtils.equals(this.pattern, style.pattern) && ObjectUtils.equals(this.isBlankWhenNull, style.isBlankWhenNull);
    }
}

