/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.extractors.AbstractJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth2.OAuth2Error;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.net.URI;

public class OAuth2AccessTokenJsonExtractor
extends AbstractJsonExtractor
implements TokenExtractor<OAuth2AccessToken> {
    protected OAuth2AccessTokenJsonExtractor() {
    }

    public static OAuth2AccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(Response response) throws IOException {
        String body = response.getBody();
        Preconditions.checkEmptyString(body, "Response body is incorrect. Can't extract a token from an empty string");
        if (response.getCode() != 200) {
            this.generateError(response);
        }
        return this.createToken(body);
    }

    public void generateError(Response response) throws IOException {
        OAuth2Error errorCode;
        URI errorUri;
        JsonNode responseBodyJson;
        String responseBody = response.getBody();
        try {
            responseBodyJson = OBJECT_MAPPER.readTree(responseBody);
        }
        catch (JsonProcessingException ex) {
            throw new OAuth2AccessTokenErrorResponse(null, null, null, response);
        }
        JsonNode errorUriInString = responseBodyJson.get("error_uri");
        try {
            errorUri = errorUriInString == null ? null : URI.create(errorUriInString.asText());
        }
        catch (IllegalArgumentException iae) {
            errorUri = null;
        }
        try {
            errorCode = OAuth2Error.parseFrom(OAuth2AccessTokenJsonExtractor.extractRequiredParameter(responseBodyJson, "error", responseBody).asText());
        }
        catch (IllegalArgumentException iaE) {
            errorCode = null;
        }
        JsonNode errorDescription = responseBodyJson.get("error_description");
        throw new OAuth2AccessTokenErrorResponse(errorCode, errorDescription == null ? null : errorDescription.asText(), errorUri, response);
    }

    private OAuth2AccessToken createToken(String rawResponse) throws IOException {
        JsonNode response = OBJECT_MAPPER.readTree(rawResponse);
        JsonNode expiresInNode = response.get("expires_in");
        JsonNode refreshToken = response.get("refresh_token");
        JsonNode scope = response.get("scope");
        JsonNode tokenType = response.get("token_type");
        return this.createToken(OAuth2AccessTokenJsonExtractor.extractRequiredParameter(response, "access_token", rawResponse).asText(), tokenType == null ? null : tokenType.asText(), expiresInNode == null ? null : Integer.valueOf(expiresInNode.asInt()), refreshToken == null ? null : refreshToken.asText(), scope == null ? null : scope.asText(), response, rawResponse);
    }

    protected OAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, JsonNode response, String rawResponse) {
        return new OAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, rawResponse);
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenJsonExtractor INSTANCE = new OAuth2AccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

