/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.NumberUtility;

final class EFloatByteArrayString {
    private EFloatByteArrayString() {
    }

    static EFloat FromString(byte[] chars, int offset, int length, EContext ctx, boolean throwException) {
        if (chars == null) {
            if (!throwException) {
                return null;
            }
            throw new NullPointerException("chars");
        }
        if (offset < 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + offset + ") is not greater or equal to 0");
        }
        if (offset > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + offset + ") is not less or equal to " + chars.length);
        }
        if (length < 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is not greater or equal to 0");
        }
        if (length > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is not less or equal to " + chars.length);
        }
        if (chars.length - offset < length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("str's length minus " + offset + "(" + (chars.length - offset) + ") is not greater or equal to " + length);
        }
        EContext b64 = EContext.Binary64;
        if (ctx != null && ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && !ctx.isSimplified() && ctx.getEMax().compareTo(b64.getEMax()) <= 0 && ctx.getEMin().compareTo(b64.getEMin()) >= 0 && ctx.getPrecision().compareTo(b64.getPrecision()) <= 0) {
            EFloat ef;
            int tmpoffset = offset;
            int endpos = offset + length;
            if (length == 0) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            if (chars[tmpoffset] == 45 || chars[tmpoffset] == 43) {
                ++tmpoffset;
            }
            if (tmpoffset < endpos && (chars[tmpoffset] >= 48 && chars[tmpoffset] <= 57 || chars[tmpoffset] == 46) && (ef = EFloatByteArrayString.DoubleEFloatFromString(chars, offset, length, ctx, throwException)) != null) {
                return ef;
            }
        }
        return EDecimal.FromString(chars, offset, length, EContext.Unlimited.WithSimplified(ctx != null && ctx.isSimplified())).ToEFloat(ctx);
    }

    static EFloat DoubleEFloatFromString(byte[] chars, int offset, int length, EContext ctx, boolean throwException) {
        EInteger exp;
        int tmpoffset = offset;
        if (chars == null) {
            if (!throwException) {
                return null;
            }
            throw new NullPointerException("chars");
        }
        if (length == 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        int endStr = tmpoffset + length;
        boolean negative = false;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        int digitStart = 0;
        int i = tmpoffset;
        long mantissaLong = 0L;
        if (chars[i] == 43 || chars[i] == 45) {
            if (chars[i] == 45) {
                negative = true;
            }
            ++i;
        }
        digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int decimalDigitEnd = i;
        boolean nonzeroBeyondMax = false;
        int lastdigit = -1;
        int maxDecimalPrec = 768;
        if (length > 21) {
            int eminInt = ctx.getEMin().ToInt32Checked();
            int emaxInt = ctx.getEMax().ToInt32Checked();
            int precInt = ctx.getPrecision().ToInt32Checked();
            if (eminInt >= -14 && emaxInt <= 15) {
                maxDecimalPrec = precInt <= 11 ? 21 : 63;
            } else if (eminInt >= -126 && emaxInt <= 127) {
                int n = maxDecimalPrec = precInt <= 24 ? 113 : 142;
            }
        }
        while (i < endStr) {
            byte ch = chars[i];
            if (ch >= 48 && ch <= 57) {
                int thisdigit = ch - 48;
                haveDigits = true;
                haveNonzeroDigit |= thisdigit != 0;
                if (decimalPrec > maxDecimalPrec) {
                    if (thisdigit != 0) {
                        nonzeroBeyondMax = true;
                    }
                    if (!haveDecimalPoint) {
                        ++newScaleInt;
                    }
                } else {
                    lastdigit = thisdigit;
                    if (haveNonzeroDigit) {
                        ++decimalPrec;
                    }
                    if (haveDecimalPoint) {
                        decimalDigitEnd = i + 1;
                    } else {
                        digitEnd = i + 1;
                    }
                    if (mantissaLong < 0xCCCCCCCCCCCCCCCL || mantissaLong == 0xCCCCCCCCCCCCCCCL && thisdigit <= 7) {
                        mantissaLong *= 10L;
                        mantissaLong += (long)thisdigit;
                    } else {
                        mantissaLong = Long.MAX_VALUE;
                    }
                    if (haveDecimalPoint) {
                        --newScaleInt;
                    }
                }
            } else if (ch == 46) {
                if (haveDecimalPoint) {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
            } else {
                if (ch == 69 || ch == 101) {
                    haveExponent = true;
                    ++i;
                    break;
                }
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        boolean zeroMantissa = !haveNonzeroDigit;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            byte ch = chars[i];
            if (ch == 43 || ch == 45) {
                if (ch == 45) {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                ch = chars[i];
                if (ch >= 48 && ch <= 57) {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt < 0xCCCCCCC || expInt == 0xCCCCCCC && thisdigit < 7) {
                        expInt *= 10;
                        expInt += thisdigit;
                    } else {
                        expInt = Integer.MAX_VALUE;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            expInt *= expoffset;
            if (expPrec > 12) {
                if (expoffset < 0) {
                    return EFloat.SignalUnderflow(ctx, negative, zeroMantissa);
                }
                return EFloat.SignalOverflow(ctx, negative, zeroMantissa);
            }
        }
        if (i != endStr) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (!(expInt == Integer.MAX_VALUE || expInt <= -2147483647 || mantissaLong == Long.MAX_VALUE || ctx != null && ctx.getHasFlagsOrTraps())) {
            if (mantissaLong == 0L) {
                EFloat ef = EFloat.Create(EInteger.FromInt32(0), EInteger.FromInt32(expInt));
                if (negative) {
                    ef = ef.Negate();
                }
                return ef.RoundToPrecision(ctx);
            }
            long finalexp = (long)expInt + (long)newScaleInt;
            long ml = mantissaLong;
            if (finalexp >= -22L && finalexp <= 44L) {
                int iexp;
                for (iexp = (int)finalexp; ml <= 0x3333333333333L && iexp > 22; ml *= 10L, --iexp) {
                }
                int iabsexp = Math.abs(iexp);
                if (ml < 0x20000000000000L && iabsexp == 0) {
                    return EFloat.FromInt64(negative ? -mantissaLong : mantissaLong).RoundToPrecision(ctx);
                }
                if (ml < 0x20000000000000L && iabsexp <= 22) {
                    EFloat efn = EFloat.FromEInteger(NumberUtility.FindPowerOfTen(iabsexp));
                    if (negative) {
                        ml = -ml;
                    }
                    EFloat efml = EFloat.FromInt64(ml);
                    if (iexp < 0) {
                        return efml.Divide(efn, ctx);
                    }
                    return efml.Multiply(efn, ctx);
                }
            }
            long adjexpUpperBound = finalexp + (long)(decimalPrec - 1);
            long adjexpLowerBound = finalexp;
            if (adjexpUpperBound < -326L) {
                return EFloat.SignalUnderflow(ctx, negative, zeroMantissa);
            }
            if (adjexpLowerBound > 309L) {
                return EFloat.SignalOverflow(ctx, negative, zeroMantissa);
            }
            if (negative) {
                mantissaLong = -mantissaLong;
            }
            long absfinalexp = Math.abs(finalexp);
            EFloat ef1 = EFloat.Create(mantissaLong, 0);
            EFloat ef2 = EFloat.FromEInteger(NumberUtility.FindPowerOfTen(absfinalexp));
            if (finalexp < 0L) {
                EFloat efret = ef1.Divide(ef2, ctx);
                return efret;
            }
            return ef1.Multiply(ef2, ctx);
        }
        EInteger mant = null;
        EInteger eInteger = exp = !haveExponent ? EInteger.FromInt32(0) : EInteger.FromSubstring(chars, expDigitStart, endStr);
        if (expoffset < 0) {
            exp = exp.Negate();
        }
        exp = exp.Add(newScaleInt);
        if (nonzeroBeyondMax) {
            exp = exp.Subtract(1);
            ++decimalPrec;
        }
        EInteger adjExpUpperBound = exp.Add(decimalPrec).Subtract(1);
        EInteger adjExpLowerBound = exp;
        if (adjExpUpperBound.compareTo(-326) < 0) {
            return EFloat.SignalUnderflow(ctx, negative, zeroMantissa);
        }
        if (adjExpLowerBound.compareTo(309) > 0) {
            return EFloat.SignalOverflow(ctx, negative, zeroMantissa);
        }
        if (zeroMantissa) {
            EFloat ef = EFloat.Create(EInteger.FromInt32(0), exp);
            if (negative) {
                ef = ef.Negate();
            }
            return ef.RoundToPrecision(ctx);
        }
        if (decimalDigitStart != decimalDigitEnd) {
            if (digitEnd - digitStart == 1 && chars[digitStart] == 48) {
                mant = EInteger.FromSubstring(chars, decimalDigitStart, decimalDigitEnd);
            } else {
                byte[] ctmpstr = Extras.CharsConcat(chars, digitStart, digitEnd - digitStart, chars, decimalDigitStart, decimalDigitEnd - decimalDigitStart);
                mant = EInteger.FromString(ctmpstr);
            }
        } else {
            mant = EInteger.FromSubstring(chars, digitStart, digitEnd);
        }
        if (nonzeroBeyondMax) {
            mant = mant.Multiply(10).Add(1);
        }
        if (negative) {
            mant = mant.Negate();
        }
        return EDecimal.Create(mant, exp).ToEFloat(ctx);
    }
}

