/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.token.BaseOidcJsonWebKeyTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.jwt.JsonWebTokenEncryptor;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcIdTokenSigningAndEncryptionService
extends BaseOidcJsonWebKeyTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenSigningAndEncryptionService.class);
    private final OidcServerDiscoverySettings discoverySettings;

    public OidcIdTokenSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService, OidcServerDiscoverySettings discoverySettings) {
        super(defaultJsonWebKeystoreCache, serviceJsonWebKeystoreCache, issuerService);
        this.discoverySettings = discoverySettings;
    }

    public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService service) {
        OidcRegisteredService svc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
        if (StringUtils.isBlank((CharSequence)svc.getIdTokenSigningAlg())) {
            return super.getJsonWebKeySigningAlgorithm(service);
        }
        return svc.getIdTokenSigningAlg();
    }

    public boolean shouldSignToken(OAuthRegisteredService svc) {
        if (svc instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)svc;
            if (!service.isSignIdToken()) {
                LOGGER.trace("Service [{}] does not require ID token to be signed", (Object)svc.getServiceId());
                return false;
            }
            if (service.isSignIdToken() && "none".equalsIgnoreCase(service.getIdTokenSigningAlg())) {
                if (!this.discoverySettings.getIdTokenSigningAlgValuesSupported().contains("none")) {
                    LOGGER.error("Service [{}] has defined 'none' for ID token signing algorithm, yet CAS is configured to support the following signing algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)svc.getServiceId(), this.discoverySettings.getIdTokenSigningAlgValuesSupported());
                    throw new IllegalArgumentException("Unable to use 'none' as ID token signing algorithm");
                }
                LOGGER.error("Service [{}] has defined 'none' for ID token signing algorithm", (Object)svc.getServiceId());
                return false;
            }
            return service.isSignIdToken();
        }
        return false;
    }

    public boolean shouldEncryptToken(OAuthRegisteredService svc) {
        if (svc instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)svc;
            if (service.isEncryptIdToken() && "none".equalsIgnoreCase(service.getIdTokenEncryptionAlg())) {
                if (!this.discoverySettings.getIdTokenSigningAlgValuesSupported().contains("none")) {
                    LOGGER.error("Service [{}] has defined 'none' for ID token encryption algorithm, yet CAS is configured to support the following encryption algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)svc.getServiceId(), this.discoverySettings.getIdTokenEncryptionAlgValuesSupported());
                    throw new IllegalArgumentException("Unable to use 'none' as ID token encryption algorithm");
                }
                LOGGER.error("Service [{}] has defined 'none' for ID token encryption algorithm", (Object)svc.getServiceId());
                return false;
            }
            return service.isEncryptIdToken() && StringUtils.isNotBlank((CharSequence)service.getIdTokenEncryptionAlg()) && StringUtils.isNotBlank((CharSequence)service.getIdTokenEncryptionEncoding());
        }
        return false;
    }

    public Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService svc) {
        return this.discoverySettings.getIdTokenSigningAlgValuesSupported();
    }

    @Override
    protected String encryptToken(OAuthRegisteredService service, String innerJwt) {
        if (service instanceof OidcRegisteredService) {
            OidcRegisteredService svc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeyForEncryption((OAuthRegisteredService)svc);
            return JsonWebTokenEncryptor.builder().key((Key)jsonWebKey.getPublicKey()).keyId(jsonWebKey.getKeyId()).algorithm(svc.getIdTokenEncryptionAlg()).encryptionMethod(svc.getIdTokenEncryptionEncoding()).allowedAlgorithms(this.discoverySettings.getIdTokenEncryptionAlgValuesSupported()).allowedContentEncryptionAlgorithms(this.discoverySettings.getIdTokenEncryptionEncodingValuesSupported()).build().encrypt((Serializable)((Object)innerJwt));
        }
        return innerJwt;
    }
}

