/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.combobox;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.event.ISelectionChangedListener;
import org.wicketstuff.kendo.ui.KendoDataSource;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.ajax.OnChangeAjaxBehavior;

public abstract class ComboBoxBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoComboBox";
    private final ISelectionChangedListener listener;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;
    private KendoDataSource dataSource;

    public ComboBoxBehavior(String selector, ISelectionChangedListener listener) {
        super(selector, METHOD);
        this.listener = (ISelectionChangedListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isSelectionChangedEventEnabled()) {
            this.onChangeAjaxBehavior = new OnChangeAjaxBehavior(this, new FormComponent[0]);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    protected abstract CharSequence getDataSourceUrl();

    public String getDataSourceName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("autoBind", true);
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.getDataSourceName());
        if (this.isEnabled(component)) {
            this.dataSource.setTransportReadUrl(this.getDataSourceUrl());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.listener.onSelectionChanged(target);
        }
    }
}

