/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

public class GoogleAuthenticatorRestHttpRequestCredentialFactory
implements RestHttpRequestCredentialFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorRestHttpRequestCredentialFactory.class);
    public static final String PARAMETER_NAME_GAUTH_OTP = "gauthotp";
    public static final String PARAMETER_NAME_GAUTH_ACCT = "gauthacct";

    public List<Credential> fromRequest(HttpServletRequest request, MultiValueMap<String, String> requestBody) {
        if (requestBody == null || requestBody.isEmpty()) {
            LOGGER.debug("Skipping [{}] because the requestBody is null or empty", (Object)this.getClass().getSimpleName());
            return new ArrayList<Credential>();
        }
        String token = (String)requestBody.getFirst((Object)PARAMETER_NAME_GAUTH_OTP);
        String id = (String)requestBody.getFirst((Object)PARAMETER_NAME_GAUTH_ACCT);
        LOGGER.debug("Google authenticator token [{}] in the request body via account [{}]", (Object)token, (Object)id);
        if (StringUtils.isBlank((CharSequence)token)) {
            return new ArrayList<Credential>();
        }
        GoogleAuthenticatorTokenCredential creds = new GoogleAuthenticatorTokenCredential(token, StringUtils.isNotBlank((CharSequence)id) ? Long.valueOf(id) : null);
        return CollectionUtils.wrap((Object)this.prepareCredential(request, (Credential)creds));
    }
}

