/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.button;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.kendo.ui.form.button.AjaxIndicatingButtonBehavior;
import org.wicketstuff.kendo.ui.form.button.Button;
import org.wicketstuff.kendo.ui.form.button.ButtonBehavior;
import org.wicketstuff.kendo.ui.form.button.IIndicatingButton;

public class IndicatingButton
extends Button
implements IIndicatingButton {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IndicatingButton.class);

    public IndicatingButton(String id) {
        super(id);
    }

    public IndicatingButton(String id, IModel<String> model) {
        super(id, model);
    }

    @Override
    public boolean isDisabledOnClick() {
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("IndicatingButton should be applied on a 'button' tag");
        }
    }

    @Override
    public ButtonBehavior newWidgetBehavior(String selector) {
        return new AjaxIndicatingButtonBehavior(selector);
    }
}

