/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.exception;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;

public class ResponseException
extends Exception {
    private final ResponseStatusCode responseStatusCode;
    private final String remoteStackTrace;
    private final List<String> remoteExceptionHierarchy;
    private final Map<String, Object> attributes;

    public ResponseException(ResponseStatusCode responseStatusCode, String serverMessage) {
        this(responseStatusCode, serverMessage, null, null);
    }

    public ResponseException(ResponseStatusCode responseStatusCode, String serverMessage, List<String> remoteExceptionHierarchy, String remoteStackTrace) {
        this(responseStatusCode, serverMessage, remoteExceptionHierarchy, remoteStackTrace, null);
    }

    public ResponseException(ResponseStatusCode responseStatusCode, String serverMessage, List<String> remoteExceptionHierarchy, String remoteStackTrace, Map<String, Object> statusAttributes) {
        super(serverMessage);
        this.responseStatusCode = responseStatusCode;
        this.remoteExceptionHierarchy = remoteExceptionHierarchy != null ? Collections.unmodifiableList(remoteExceptionHierarchy) : null;
        this.remoteStackTrace = remoteStackTrace;
        this.attributes = statusAttributes != null ? Collections.unmodifiableMap(statusAttributes) : null;
    }

    public ResponseStatusCode getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Optional<String> getRemoteStackTrace() {
        return Optional.ofNullable(this.remoteStackTrace);
    }

    public Optional<List<String>> getRemoteExceptionHierarchy() {
        return Optional.ofNullable(this.remoteExceptionHierarchy);
    }

    public Optional<Map<String, Object>> getStatusAttributes() {
        return Optional.ofNullable(this.attributes);
    }
}

