/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class DoubleRangeValidator
implements Validator,
PartialStateHolder {
    public static final String VALIDATOR_ID = "jakarta.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "jakarta.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "jakarta.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "jakarta.faces.validator.DoubleRangeValidator.TYPE";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "jakarta.faces.validator.DoubleRangeValidator.NOT_IN_RANGE";
    private Double _minimum = null;
    private Double _maximum = null;
    private boolean _transient = false;
    private boolean _initialStateMarked = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        this._maximum = new Double(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        this._maximum = new Double(maximum);
        this._minimum = new Double(minimum);
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return;
        }
        double dvalue = this.parseDoubleValue(facesContext, uiComponent, value);
        if (this._minimum != null && this._maximum != null) {
            if (dvalue < this._minimum || dvalue > this._maximum) {
                Object[] args = new Object[]{this._minimum, this._maximum, MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(MessageUtils.getErrorMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, args));
            }
        } else if (this._minimum != null) {
            if (dvalue < this._minimum) {
                Object[] args = new Object[]{this._minimum, MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(MessageUtils.getErrorMessage(facesContext, MINIMUM_MESSAGE_ID, args));
            }
        } else if (this._maximum != null && dvalue > this._maximum) {
            Object[] args = new Object[]{this._maximum, MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(MessageUtils.getErrorMessage(facesContext, MAXIMUM_MESSAGE_ID, args));
        }
    }

    private double parseDoubleValue(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(MessageUtils.getErrorMessage(facesContext, TYPE_MESSAGE_ID, args));
        }
    }

    public double getMaximum() {
        return this._maximum != null ? this._maximum : Double.MAX_VALUE;
    }

    public void setMaximum(double maximum) {
        this._maximum = maximum;
        this.clearInitialState();
    }

    public double getMinimum() {
        return this._minimum != null ? this._minimum : Double.MIN_VALUE;
    }

    public void setMinimum(double minimum) {
        this._minimum = minimum;
        this.clearInitialState();
    }

    @Override
    public Object saveState(FacesContext context) {
        Assert.notNull(context, "context");
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this._maximum, this._minimum};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Assert.notNull(context, "context");
        if (state != null) {
            Object[] values = (Object[])state;
            this._maximum = (Double)values[0];
            this._minimum = (Double)values[1];
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator doubleRangeValidator = (DoubleRangeValidator)o;
        if (this._maximum != null ? !this._maximum.equals(doubleRangeValidator._maximum) : doubleRangeValidator._maximum != null) {
            return false;
        }
        return !(this._minimum != null ? !this._minimum.equals(doubleRangeValidator._minimum) : doubleRangeValidator._minimum != null);
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }

    public int hashCode() {
        int result = this._minimum != null ? this._minimum.hashCode() : 0;
        result = 31 * result + (this._maximum != null ? this._maximum.hashCode() : 0);
        return result;
    }
}

