/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CommonInputDialog
extends AbstractDialogKeyVerify {
    public static final int PLAIN_NAME = 1;
    public static final int DOTTED_NAME = 2;
    public static final int SPACED_NAMES = 4;
    public static final int LANGUAGE = 8;
    public static final int ALLOK = 16;
    public static final int TRUE_FALSE = 32;
    public static final int INTEGER = 64;
    public static final int FLOAT = 128;
    public static final int GROUP_NAMES = 14;
    private int validation;
    private String existing;
    private StyledText text;
    private String result;

    public CommonInputDialog(AbstractSection aSection, String title, String dialogDescription, int aKind) {
        super(aSection, title, dialogDescription);
        this.validation = aKind;
    }

    public CommonInputDialog(AbstractSection aSection, String title, String dialogDescription, int aKind, String aExisting) {
        this(aSection, title, dialogDescription, aKind);
        this.existing = aExisting;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existing);
        this.text = this.newSingleLineStyledText(mainArea, "");
        AbstractSection.spacer(mainArea);
        this.newErrorMessage(mainArea);
        if (null != this.existing) {
            this.text.setText(this.existing);
        } else {
            this.text.setText("");
        }
        return mainArea;
    }

    @Override
    public boolean verifyKeyChecks(VerifyEvent event) {
        boolean validateFloat;
        char ch = event.character;
        boolean validateDottedName = (this.validation & 2) == 2;
        boolean validateSpaces = (this.validation & 4) == 4;
        boolean validateLanguage = (this.validation & 8) == 8;
        boolean validateAllOK = (this.validation & 0x10) == 16;
        boolean validateTrueFalse = (this.validation & 0x20) == 32;
        boolean validateInteger = (this.validation & 0x40) == 64;
        boolean bl = validateFloat = (this.validation & 0x80) == 128;
        if (event.keyCode == 13 || event.keyCode == 9 || event.keyCode == 8) {
            return true;
        }
        if (validateTrueFalse) {
            return "truefalse".indexOf(ch) >= 0;
        }
        if (validateSpaces && ch == ' ') {
            return true;
        }
        if (validateDottedName && ch == '.') {
            return true;
        }
        if (!validateTrueFalse && !validateInteger && !validateFloat && Character.isJavaIdentifierPart(ch)) {
            return true;
        }
        if (validateLanguage && ch == '-') {
            return true;
        }
        if (validateAllOK) {
            return true;
        }
        if (validateInteger && (Character.isDigit(ch) || ch == '-')) {
            return true;
        }
        return validateFloat && (Character.isDigit(ch) || ch == '-' || ch == 'E' || ch == 'e' || ch == '.');
    }

    public String getValue() {
        return this.result;
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled("".equals(this.errorMessageUI.getText()) && this.text.getText().length() > 0);
    }

    @Override
    public void copyValuesFromGUI() {
        this.result = this.text.getText();
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

