/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.number;

import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.number.AbstractNumberExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class ComposedNumberExpression
extends AbstractNumberExpression {
    private final List<INumberExpression> expressions;
    private final List<String> ops;

    public ComposedNumberExpression(List<INumberExpression> expressions, List<String> ops) {
        this.expressions = expressions;
        this.ops = ops;
    }

    @Override
    public double getDoubleValue(MatchContext context, RutaStream stream) {
        INumberExpression numberExpression = this.getExpressions().get(0);
        if (numberExpression == null) {
            return 0.0;
        }
        double result = numberExpression.getDoubleValue(context, stream);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            double second = 0.0;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getDoubleValue(context, stream);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public float getFloatValue(MatchContext context, RutaStream stream) {
        INumberExpression numberExpression = this.getExpressions().get(0);
        if (numberExpression == null) {
            return 0.0f;
        }
        float result = numberExpression.getFloatValue(context, stream);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            float second = 0.0f;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getFloatValue(context, stream);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public int getIntegerValue(MatchContext context, RutaStream stream) {
        int result = this.getExpressions().get(0).getIntegerValue(context, stream);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            int second = 0;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getIntegerValue(context, stream);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        if (this.ops.isEmpty() && this.expressions.size() == 1) {
            return this.expressions.get(0).getStringValue(context, stream);
        }
        return String.valueOf(this.getDoubleValue(context, stream));
    }

    public List<INumberExpression> getExpressions() {
        return this.expressions;
    }

    public List<String> getOperators() {
        return this.ops;
    }
}

