/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.internal.util.ClassLoaderUtils;
import org.apache.uima.internal.util.WeakIdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_BROKEN_SERVICES = 16;
    private static final WeakIdentityMap<ClassLoader, Map<Class<?>, List<?>>> cl_to_services = WeakIdentityMap.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceCache() {
        WeakIdentityMap<ClassLoader, Map<Class<?>, List<?>>> weakIdentityMap = cl_to_services;
        synchronized (weakIdentityMap) {
            cl_to_services.clear();
        }
    }

    public static <T> Stream<T> loadServicesSafely(Class<T> aService) {
        ClassLoader cl = ClassLoaderUtils.findClassLoader();
        return ServiceLoaderUtil.loadServicesSafely(aService, cl, null);
    }

    public static <T> Stream<T> loadServicesSafely(Class<T> aService, ClassLoader aClassLoader) {
        return ServiceLoaderUtil.loadServicesSafely(aService, aClassLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Stream<T> loadServicesSafely(Class<T> aService, ClassLoader aClassLoader, Collection<Throwable> aErrorCollector) {
        Map<Class<?>, List<?>> servicesMap;
        Object object = cl_to_services;
        synchronized (object) {
            servicesMap = cl_to_services.get(aClassLoader);
            if (servicesMap == null) {
                servicesMap = new LinkedHashMap();
                cl_to_services.put(aClassLoader, servicesMap);
            }
        }
        object = servicesMap;
        synchronized (object) {
            List<Object> services = servicesMap.get(aService);
            if (services == null) {
                ServiceLoader<T> loader = ServiceLoader.load(aService, aClassLoader);
                services = StreamSupport.stream(new ServiceLoaderSpliterator<T>(aService, loader.iterator(), aErrorCollector), false).toList();
                servicesMap.put(aService, services);
            }
            return services.stream();
        }
    }

    private static class ServiceLoaderSpliterator<T>
    implements Spliterator<T> {
        private final Logger log;
        private final Iterator<T> serviceIterator;
        private final Class<T> service;
        private final Collection<Throwable> errorCollector;

        public ServiceLoaderSpliterator(Class<T> aService, Iterator<T> aIterator, Collection<Throwable> aErrorCollector) {
            this.serviceIterator = aIterator;
            this.service = aService;
            this.errorCollector = aErrorCollector;
            this.log = aErrorCollector == null ? LOG : null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> aAction) {
            int i = 16;
            while (i-- > 0) {
                try {
                    if (!this.serviceIterator.hasNext()) continue;
                    aAction.accept(this.serviceIterator.next());
                    return true;
                }
                catch (LinkageError | ServiceConfigurationError e) {
                    this.handle(e);
                }
                catch (Throwable e) {
                    this.handle(e);
                    throw e;
                }
            }
            return false;
        }

        private void handle(Throwable e) {
            if (this.log != null) {
                this.log.warn("Unable to load service class for service {}", this.service, (Object)e);
            }
            if (this.errorCollector != null) {
                this.errorCollector.add(e);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1280;
        }
    }
}

