/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.uima.fit.descriptor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Provides information on the languages supported by a component.
 * 
 * <pre>
 * <code>
 * {@literal @}LanguageCapability({ "en", "de" })
 * </code>
 * </pre>
 */

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface LanguageCapability {
  /**
   * The languages supported by this component.
   * 
   * @return the supported languages
   */
  String[] value() default NO_DEFAULT_VALUE;

  /**
   * Provides the default value that tells the CapabilityFactory that no value has been provided.
   */
  public static final String NO_DEFAULT_VALUE = "org.apache.uima.fit.descriptor.LanguageCapability.NO_DEFAULT_VALUE";
}
