/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventsCollectorRequest;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.rest.models.EventCollectorResponse;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.apache.unomi.utils.EventsRequestContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/")
@Component(service={EventsCollectorEndpoint.class}, property={"osgi.jaxrs.resource=true"})
public class EventsCollectorEndpoint {
    public static final String SYSTEMSCOPE = "systemscope";
    @Reference
    private RestServiceUtils restServiceUtils;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;

    @OPTIONS
    @Path(value="/eventcollector")
    public Response options() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/eventcollector")
    public EventCollectorResponse collectAsGet(@QueryParam(value="payload") EventsCollectorRequest eventsCollectorRequest, @QueryParam(value="timestamp") Long timestampAsString) {
        return this.doEvent(eventsCollectorRequest, timestampAsString);
    }

    @POST
    @Path(value="/eventcollector")
    public EventCollectorResponse collectAsPost(EventsCollectorRequest eventsCollectorRequest, @QueryParam(value="timestamp") Long timestampAsLong) {
        return this.doEvent(eventsCollectorRequest, timestampAsLong);
    }

    private EventCollectorResponse doEvent(EventsCollectorRequest eventsCollectorRequest, Long timestampAsLong) {
        String sessionId;
        if (eventsCollectorRequest == null) {
            throw new InvalidRequestException("events collector cannot be empty", "Invalid received data");
        }
        Date timestamp = new Date();
        if (timestampAsLong != null) {
            timestamp = new Date(timestampAsLong);
        }
        if ((sessionId = eventsCollectorRequest.getSessionId()) == null) {
            sessionId = this.request.getParameter("sessionId");
        }
        String profileId = eventsCollectorRequest.getProfileId();
        String scope = SYSTEMSCOPE;
        List events = eventsCollectorRequest.getEvents();
        for (Event event : events) {
            if (!StringUtils.isNotBlank((CharSequence)event.getEventType())) continue;
            if (StringUtils.isNotBlank((CharSequence)event.getScope()) && !event.getScope().equals(SYSTEMSCOPE)) {
                scope = event.getScope();
                break;
            }
            if (event.getSource() == null || !StringUtils.isNotBlank((CharSequence)event.getSource().getScope()) || event.getSource().getScope().equals(SYSTEMSCOPE)) continue;
            scope = event.getSource().getScope();
            break;
        }
        EventsRequestContext eventsRequestContext = this.restServiceUtils.initEventsRequest(scope, sessionId, profileId, null, false, false, this.request, this.response, timestamp);
        eventsRequestContext = this.restServiceUtils.performEventsRequest(eventsCollectorRequest.getEvents(), eventsRequestContext);
        this.restServiceUtils.finalizeEventsRequest(eventsRequestContext, true);
        return new EventCollectorResponse(eventsRequestContext.getChanges());
    }
}

