/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.request.mapper.MapperUtils;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractComponentMapper
extends AbstractMapper
implements IRequestMapper {
    protected IMapperContext getContext() {
        return Application.get().getMapperContext();
    }

    protected PageComponentInfo getPageComponentInfo(Url url) {
        return MapperUtils.getPageComponentInfo(url);
    }

    protected void encodePageComponentInfo(Url url, PageComponentInfo info) {
        String s;
        Args.notNull((Object)url, (String)"url");
        if (info != null && !Strings.isEmpty((String)(s = info.toString()))) {
            Url.QueryParameter parameter = new Url.QueryParameter(s, "");
            url.getQueryParameters().add(parameter);
        }
    }

    protected Class<? extends IRequestablePage> getPageClass(String name) {
        String cleanedClassName = this.cleanClassName(name);
        return WicketObjects.resolveClass(cleanedClassName);
    }

    protected String cleanClassName(String className) {
        Args.notEmpty((String)className, (String)"className");
        if (Strings.indexOf((CharSequence)className, (char)';') > -1) {
            className = Strings.beforeFirst((String)className, (char)';');
        }
        return className;
    }

    protected void removeMetaParameter(Url urlCopy) {
        if (MapperUtils.parsePageComponentInfoParameter((Url.QueryParameter)urlCopy.getQueryParameters().get(0)) != null) {
            urlCopy.getQueryParameters().remove(0);
        }
    }
}

