/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Component;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;

public class ComponentDetachableModel<T>
implements IComponentAssignedModel<T> {
    private static final long serialVersionUID = 1L;
    private transient boolean attached = false;

    @Override
    public final T getObject() {
        throw new RuntimeException("get object call not expected on a IComponentAssignedModel");
    }

    @Override
    public final void setObject(T object) {
        throw new RuntimeException("set object call not expected on a IComponentAssignedModel");
    }

    public final boolean isAttached() {
        return this.attached;
    }

    protected final void setAttached() {
        this.attached = true;
    }

    protected void attach() {
    }

    protected T getObject(Component component) {
        return null;
    }

    protected void setObject(Component component, T object) {
    }

    @Override
    public IWrapModel<T> wrapOnAssignment(Component comp) {
        return new WrapModel(comp);
    }

    private class WrapModel<P>
    implements IWrapModel<T> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public WrapModel(Component comp) {
            this.component = comp;
        }

        @Override
        public IModel<T> getWrappedModel() {
            return ComponentDetachableModel.this;
        }

        private void attach() {
            if (!ComponentDetachableModel.this.attached) {
                ComponentDetachableModel.this.attached = true;
                ComponentDetachableModel.this.attach();
            }
        }

        @Override
        public T getObject() {
            this.attach();
            return ComponentDetachableModel.this.getObject(this.component);
        }

        @Override
        public void setObject(T object) {
            this.attach();
            ComponentDetachableModel.this.setObject(this.component, object);
        }

        @Override
        public void detach() {
            if (ComponentDetachableModel.this.attached) {
                ComponentDetachableModel.this.attached = false;
                ComponentDetachableModel.this.detach();
            }
        }
    }
}

