/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.core.request.handler.IComponentRequestHandler;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.ListenerInvocationNotAllowedException;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.ListenerLogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler,
ILoggableRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerRequestHandler.class);
    private final IPageAndComponentProvider pageComponentProvider;
    private final Integer behaviorId;
    private ListenerLogData logData;

    public ListenerRequestHandler(IPageAndComponentProvider pageComponentProvider, Integer behaviorIndex) {
        Args.notNull(pageComponentProvider, "pageComponentProvider");
        this.pageComponentProvider = pageComponentProvider;
        this.behaviorId = behaviorIndex;
    }

    public ListenerRequestHandler(PageAndComponentProvider pageComponentProvider) {
        this(pageComponentProvider, null);
    }

    public boolean includeRenderCount() {
        if (this.behaviorId == null) {
            return ((IRequestListener)((Object)this.getComponent())).rendersPage();
        }
        return ((IRequestListener)((Object)this.getComponent().getBehaviorById(this.getBehaviorIndex()))).rendersPage();
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageComponentProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new ListenerLogData(this.pageComponentProvider, this.behaviorId);
        }
        this.pageComponentProvider.detach();
    }

    public Integer getBehaviorIndex() {
        return this.behaviorId;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        boolean lateComponent;
        IRequestableComponent component;
        IRequestablePage page = this.getPage();
        boolean freshPage = this.pageComponentProvider.doesProvideNewPage();
        boolean isAjax = ((WebRequest)requestCycle.getRequest()).isAjax();
        try {
            component = this.getComponent();
        }
        catch (ComponentNotFoundException e) {
            component = null;
        }
        if (component == null && !freshPage || component != null && component.getPage() != page) {
            throw new ComponentNotFoundException("Component '" + this.getComponentPath() + "' has been removed from page.");
        }
        RenderPageRequestHandler.RedirectPolicy policy = page.isPageStateless() ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT;
        boolean blockIfExpired = component != null && !component.canCallListenerAfterExpiry();
        boolean bl = lateComponent = component == null && freshPage;
        if (this.pageComponentProvider.wasExpired() && blockIfExpired || lateComponent) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An IRequestListener was called but its page/component({}) couldn't be resolved. Scheduling re-create of the page and ignoring the listener interface...", (Object)this.getComponentPath());
            }
            if (isAjax) {
                policy = RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
            }
            requestCycle.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(new PageProvider(page), policy));
            return;
        }
        this.invokeListener(requestCycle, policy, isAjax);
    }

    private void invokeListener(IRequestCycle requestCycle, RenderPageRequestHandler.RedirectPolicy policy, boolean ajax) {
        if (this.getBehaviorIndex() == null) {
            this.invoke(requestCycle, policy, ajax, this.getComponent());
        } else {
            Behavior behavior;
            try {
                behavior = this.getComponent().getBehaviorById(this.behaviorId);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WicketRuntimeException("Couldn't find component behavior.", e);
            }
            this.invoke(requestCycle, policy, ajax, this.getComponent(), behavior);
        }
    }

    private final void invoke(IRequestCycle requestCycle, RenderPageRequestHandler.RedirectPolicy policy, boolean ajax, IRequestableComponent rcomponent) {
        Component component = (Component)rcomponent;
        if (!component.canCallListener()) {
            LOG.info("component not enabled or visible; ignoring call. Component: " + String.valueOf(component));
            throw new ListenerInvocationNotAllowedException(component, null, "Component rejected interface invocation");
        }
        this.internalInvoke(requestCycle, policy, ajax, component, component);
    }

    private final void invoke(IRequestCycle requestCycle, RenderPageRequestHandler.RedirectPolicy policy, boolean ajax, IRequestableComponent rcomponent, Behavior behavior) {
        Component component = (Component)rcomponent;
        if (!behavior.canCallListener(component)) {
            LOG.warn("behavior not enabled; ignore call. Behavior {} at component {}", (Object)behavior, (Object)component);
            throw new ListenerInvocationNotAllowedException(component, behavior, "Behavior rejected interface invocation. ");
        }
        this.internalInvoke(requestCycle, policy, ajax, component, behavior);
    }

    private void internalInvoke(IRequestCycle requestCycle, RenderPageRequestHandler.RedirectPolicy policy, boolean ajax, Component component, Object target) {
        IRequestListener requestListener;
        Page page = component.getPage();
        if (!page.isInitialized()) {
            page.internalInitialize();
        }
        if ((requestListener = (IRequestListener)target).rendersPage() && !ajax) {
            requestCycle.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(new PageProvider(page), policy));
        }
        requestListener.onRequest();
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return this.pageComponentProvider.hasPageInstance();
    }

    @Override
    public final String getComponentPath() {
        return this.pageComponentProvider.getComponentPath();
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageComponentProvider.getRenderCount();
    }

    @Override
    public ListenerLogData getLogData() {
        return this.logData;
    }
}

