/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.camel.support.ResourceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;

public class PackageScanJarResource
extends ResourceSupport {
    private final URL url;
    private final URLClassLoader uc;

    public PackageScanJarResource(String scheme, URL url, String location) {
        super(scheme, url.getFile() + FileUtil.stripPath((String)location));
        this.url = url;
        this.uc = new URLClassLoader(new URL[]{url});
    }

    public URL getURL() throws MalformedURLException {
        return this.url;
    }

    public boolean exists() {
        return true;
    }

    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        String loc = StringHelper.afterLast((String)this.getLocation(), (String)"!");
        return this.uc.getResourceAsStream(loc);
    }
}

