/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind;

import java.util.Locale;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.EnumNamingStrategy;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.util.NamingStrategyImpls;

public class EnumNamingStrategies {
    public static final EnumNamingStrategy LOWER_CAMEL_CASE = LowerCamelCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy UPPER_CAMEL_CASE = UpperCamelCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy SNAKE_CASE = SnakeCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy UPPER_SNAKE_CASE = UpperSnakeCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy LOWER_CASE = LowerCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy KEBAB_CASE = KebabCaseStrategy.INSTANCE;
    public static final EnumNamingStrategy LOWER_DOT_CASE = LowerDotCaseStrategy.INSTANCE;

    private EnumNamingStrategies() {
    }

    public static class LowerDotCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final LowerDotCaseStrategy INSTANCE = new LowerDotCaseStrategy();

        protected LowerDotCaseStrategy() {
            super(NamingStrategyImpls.LOWER_DOT_CASE);
        }
    }

    public static class KebabCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final KebabCaseStrategy INSTANCE = new KebabCaseStrategy();

        protected KebabCaseStrategy() {
            super(NamingStrategyImpls.KEBAB_CASE);
        }
    }

    public static class LowerCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final LowerCaseStrategy INSTANCE = new LowerCaseStrategy();

        protected LowerCaseStrategy() {
            super(NamingStrategyImpls.LOWER_CASE);
        }
    }

    public static class UpperSnakeCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final UpperSnakeCaseStrategy INSTANCE = new UpperSnakeCaseStrategy();

        protected UpperSnakeCaseStrategy() {
            super(NamingStrategyImpls.UPPER_SNAKE_CASE);
        }
    }

    public static class SnakeCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final SnakeCaseStrategy INSTANCE = new SnakeCaseStrategy();

        protected SnakeCaseStrategy() {
            super(NamingStrategyImpls.SNAKE_CASE);
        }
    }

    public static class UpperCamelCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final UpperCamelCaseStrategy INSTANCE = new UpperCamelCaseStrategy();

        protected UpperCamelCaseStrategy() {
            super(NamingStrategyImpls.UPPER_CAMEL_CASE);
        }
    }

    public static class LowerCamelCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final LowerCamelCaseStrategy INSTANCE = new LowerCamelCaseStrategy();

        protected LowerCamelCaseStrategy() {
            super(NamingStrategyImpls.LOWER_CAMEL_CASE);
        }
    }

    @Deprecated
    public static class CamelCaseStrategy
    extends DelegatingEnumNamingStrategy {
        public static final CamelCaseStrategy INSTANCE = new CamelCaseStrategy();

        protected CamelCaseStrategy() {
            super(NamingStrategyImpls.LOWER_CAMEL_CASE);
        }
    }

    public static abstract class DelegatingEnumNamingStrategy
    implements EnumNamingStrategy {
        private final NamingStrategyImpls strategy;

        protected DelegatingEnumNamingStrategy(NamingStrategyImpls strategy) {
            this.strategy = strategy;
        }

        @Override
        public String convertEnumToExternalName(String enumName) {
            return this.strategy.translate(DelegatingEnumNamingStrategy.toBeanName(enumName));
        }

        protected static String toBeanName(String enumName) {
            if (enumName == null) {
                return null;
            }
            String UNDERSCORE = "_";
            StringBuilder out = null;
            int iterationCnt = 0;
            int lastSeparatorIdx = -1;
            do {
                if ((lastSeparatorIdx = DelegatingEnumNamingStrategy.nextIndexOfUnderscore(enumName, lastSeparatorIdx + 1)) == -1) continue;
                if (iterationCnt == 0) {
                    out = new StringBuilder(enumName.length() + 4 * "_".length());
                    out.append(enumName.substring(iterationCnt, lastSeparatorIdx).toLowerCase(Locale.ROOT));
                } else {
                    out.append(DelegatingEnumNamingStrategy.normalizeWord(enumName.substring(iterationCnt, lastSeparatorIdx)));
                }
                iterationCnt = lastSeparatorIdx + "_".length();
            } while (lastSeparatorIdx != -1);
            if (iterationCnt == 0) {
                return enumName.toLowerCase(Locale.ROOT);
            }
            out.append(DelegatingEnumNamingStrategy.normalizeWord(enumName.substring(iterationCnt)));
            return out.toString();
        }

        private static int nextIndexOfUnderscore(CharSequence sequence, int start) {
            int length = sequence.length();
            for (int i = start; i < length; ++i) {
                if ('_' != sequence.charAt(i)) continue;
                return i;
            }
            return -1;
        }

        private static String normalizeWord(String word) {
            int length = word.length();
            if (length == 0) {
                return word;
            }
            return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
        }
    }
}

