/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages to/from Azure Service Bus.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ServiceBusEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedServiceBusEndpointConsumerBuilder advanced() {
            return (AdvancedServiceBusEndpointConsumerBuilder) this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpRetryOptions(com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpRetryOptions(String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpTransportType(com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpTransportType(String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option is a: <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder clientOptions(com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option will be converted to a
         * <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder clientOptions(String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option is a: <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder proxyOptions(com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder proxyOptions(String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusType(org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusType(String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Enable application level deadlettering to the subscription deadletter
         * subqueue if deadletter related headers are set.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableDeadLettering the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder enableDeadLettering(boolean enableDeadLettering) {
            doSetProperty("enableDeadLettering", enableDeadLettering);
            return this;
        }
        /**
         * Enable application level deadlettering to the subscription deadletter
         * subqueue if deadletter related headers are set.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableDeadLettering the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder enableDeadLettering(String enableDeadLettering) {
            doSetProperty("enableDeadLettering", enableDeadLettering);
            return this;
        }
        /**
         * Sets the amount of time to continue auto-renewing the lock. Setting
         * ZERO disables auto-renewal. For ServiceBus receive mode
         * (RECEIVE_AND_DELETE RECEIVE_AND_DELETE), auto-renewal is disabled.
         * 
         * The option is a: <code>java.time.Duration</code> type.
         * 
         * Default: 5m
         * Group: consumer
         * 
         * @param maxAutoLockRenewDuration the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(java.time.Duration maxAutoLockRenewDuration) {
            doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }
        /**
         * Sets the amount of time to continue auto-renewing the lock. Setting
         * ZERO disables auto-renewal. For ServiceBus receive mode
         * (RECEIVE_AND_DELETE RECEIVE_AND_DELETE), auto-renewal is disabled.
         * 
         * The option will be converted to a <code>java.time.Duration</code>
         * type.
         * 
         * Default: 5m
         * Group: consumer
         * 
         * @param maxAutoLockRenewDuration the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(String maxAutoLockRenewDuration) {
            doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }
        /**
         * Sets maximum number of concurrent calls.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param maxConcurrentCalls the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            doSetProperty("maxConcurrentCalls", maxConcurrentCalls);
            return this;
        }
        /**
         * Sets maximum number of concurrent calls.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param maxConcurrentCalls the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxConcurrentCalls(String maxConcurrentCalls) {
            doSetProperty("maxConcurrentCalls", maxConcurrentCalls);
            return this;
        }
        /**
         * Sets the prefetch count of the receiver. For both PEEK_LOCK PEEK_LOCK
         * and RECEIVE_AND_DELETE RECEIVE_AND_DELETE receive modes the default
         * value is 1. Prefetch speeds up the message flow by aiming to have a
         * message readily available for local retrieval when and before the
         * application asks for one using receive message. Setting a non-zero
         * value will prefetch that number of messages. Setting the value to
         * zero turns prefetch off.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the prefetch count of the receiver. For both PEEK_LOCK PEEK_LOCK
         * and RECEIVE_AND_DELETE RECEIVE_AND_DELETE receive modes the default
         * value is 1. Prefetch speeds up the message flow by aiming to have a
         * message readily available for local retrieval when and before the
         * application asks for one using receive message. Setting a non-zero
         * value will prefetch that number of messages. Setting the value to
         * zero turns prefetch off.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder prefetchCount(String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the processorClient in order to consume messages by the
         * consumer.
         * 
         * The option is a:
         * <code>com.azure.messaging.servicebus.ServiceBusProcessorClient</code>
         * type.
         * 
         * Group: consumer
         * 
         * @param processorClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder processorClient(com.azure.messaging.servicebus.ServiceBusProcessorClient processorClient) {
            doSetProperty("processorClient", processorClient);
            return this;
        }
        /**
         * Sets the processorClient in order to consume messages by the
         * consumer.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.servicebus.ServiceBusProcessorClient</code>
         * type.
         * 
         * Group: consumer
         * 
         * @param processorClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder processorClient(String processorClient) {
            doSetProperty("processorClient", processorClient);
            return this;
        }
        /**
         * Sets the receive mode for the receiver.
         * 
         * The option is a:
         * <code>com.azure.messaging.servicebus.models.ServiceBusReceiveMode</code> type.
         * 
         * Default: PEEK_LOCK
         * Group: consumer
         * 
         * @param serviceBusReceiveMode the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(com.azure.messaging.servicebus.models.ServiceBusReceiveMode serviceBusReceiveMode) {
            doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }
        /**
         * Sets the receive mode for the receiver.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.servicebus.models.ServiceBusReceiveMode</code> type.
         * 
         * Default: PEEK_LOCK
         * Group: consumer
         * 
         * @param serviceBusReceiveMode the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(String serviceBusReceiveMode) {
            doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }
        /**
         * Sets the type of the SubQueue to connect to.
         * 
         * The option is a:
         * <code>com.azure.messaging.servicebus.models.SubQueue</code> type.
         * 
         * Group: consumer
         * 
         * @param subQueue the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subQueue(com.azure.messaging.servicebus.models.SubQueue subQueue) {
            doSetProperty("subQueue", subQueue);
            return this;
        }
        /**
         * Sets the type of the SubQueue to connect to.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.servicebus.models.SubQueue</code> type.
         * 
         * Group: consumer
         * 
         * @param subQueue the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subQueue(String subQueue) {
            doSetProperty("subQueue", subQueue);
            return this;
        }
        /**
         * Sets the name of the subscription in the topic to listen to.
         * topicOrQueueName and serviceBusType=topic must also be set. This
         * property is required if serviceBusType=topic and the consumer is in
         * use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param subscriptionName the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subscriptionName(String subscriptionName) {
            doSetProperty("subscriptionName", subscriptionName);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder connectionString(String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder credentialType(org.apache.camel.component.azure.servicebus.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option is a:
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder tokenCredential(com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option will be converted to a
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder tokenCredential(String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure ServiceBus component.
     */
    public interface AdvancedServiceBusEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ServiceBusEndpointConsumerBuilder basic() {
            return (ServiceBusEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedServiceBusEndpointProducerBuilder advanced() {
            return (AdvancedServiceBusEndpointProducerBuilder) this;
        }

        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpRetryOptions(com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpRetryOptions(String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpTransportType(com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpTransportType(String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option is a: <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder clientOptions(com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option will be converted to a
         * <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder clientOptions(String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option is a: <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder proxyOptions(com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder proxyOptions(String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusType(org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusType(String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Set binary mode. If true, message body will be sent as byte. By
         * default, it is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param binary the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder binary(boolean binary) {
            doSetProperty("binary", binary);
            return this;
        }
        /**
         * Set binary mode. If true, message body will be sent as byte. By
         * default, it is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param binary the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder binary(String binary) {
            doSetProperty("binary", binary);
            return this;
        }
        /**
         * Sets the desired operation to be used in the producer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition</code> type.
         * 
         * Default: sendMessages
         * Group: producer
         * 
         * @param producerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder producerOperation(org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition producerOperation) {
            doSetProperty("producerOperation", producerOperation);
            return this;
        }
        /**
         * Sets the desired operation to be used in the producer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition</code> type.
         * 
         * Default: sendMessages
         * Group: producer
         * 
         * @param producerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder producerOperation(String producerOperation) {
            doSetProperty("producerOperation", producerOperation);
            return this;
        }
        /**
         * Sets OffsetDateTime at which the message should appear in the Service
         * Bus queue or topic.
         * 
         * The option is a: <code>java.time.OffsetDateTime</code> type.
         * 
         * Group: producer
         * 
         * @param scheduledEnqueueTime the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder scheduledEnqueueTime(java.time.OffsetDateTime scheduledEnqueueTime) {
            doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }
        /**
         * Sets OffsetDateTime at which the message should appear in the Service
         * Bus queue or topic.
         * 
         * The option will be converted to a
         * <code>java.time.OffsetDateTime</code> type.
         * 
         * Group: producer
         * 
         * @param scheduledEnqueueTime the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder scheduledEnqueueTime(String scheduledEnqueueTime) {
            doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }
        /**
         * Sets senderClient to be used in the producer.
         * 
         * The option is a:
         * <code>com.azure.messaging.servicebus.ServiceBusSenderClient</code>
         * type.
         * 
         * Group: producer
         * 
         * @param senderClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder senderClient(com.azure.messaging.servicebus.ServiceBusSenderClient senderClient) {
            doSetProperty("senderClient", senderClient);
            return this;
        }
        /**
         * Sets senderClient to be used in the producer.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.servicebus.ServiceBusSenderClient</code>
         * type.
         * 
         * Group: producer
         * 
         * @param senderClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder senderClient(String senderClient) {
            doSetProperty("senderClient", senderClient);
            return this;
        }
        /**
         * Represents transaction in service. This object just contains
         * transaction id.
         * 
         * The option is a:
         * <code>com.azure.messaging.servicebus.ServiceBusTransactionContext</code> type.
         * 
         * Group: producer
         * 
         * @param serviceBusTransactionContext the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusTransactionContext(com.azure.messaging.servicebus.ServiceBusTransactionContext serviceBusTransactionContext) {
            doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }
        /**
         * Represents transaction in service. This object just contains
         * transaction id.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.servicebus.ServiceBusTransactionContext</code> type.
         * 
         * Group: producer
         * 
         * @param serviceBusTransactionContext the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusTransactionContext(String serviceBusTransactionContext) {
            doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder connectionString(String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder credentialType(org.apache.camel.component.azure.servicebus.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option is a:
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder tokenCredential(com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option will be converted to a
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder tokenCredential(String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure ServiceBus component.
     */
    public interface AdvancedServiceBusEndpointProducerBuilder extends EndpointProducerBuilder {
        default ServiceBusEndpointProducerBuilder basic() {
            return (ServiceBusEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointBuilder
            extends
                ServiceBusEndpointConsumerBuilder,
                ServiceBusEndpointProducerBuilder {
        default AdvancedServiceBusEndpointBuilder advanced() {
            return (AdvancedServiceBusEndpointBuilder) this;
        }

        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpRetryOptions(com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpRetryOptions(String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpTransportType(com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpTransportType(String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option is a: <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder clientOptions(com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information.
         * 
         * The option will be converted to a
         * <code>com.azure.core.util.ClientOptions</code> type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder clientOptions(String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter Service Bus
         * application properties to and from Camel message headers.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option is a: <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder proxyOptions(com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderClient. When
         * a proxy is configured, AMQP_WEB_SOCKETS must be used for the
         * transport type.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.ProxyOptions</code> type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder proxyOptions(String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder serviceBusType(org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.ServiceBusType</code> type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder serviceBusType(String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder connectionString(String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder credentialType(org.apache.camel.component.azure.servicebus.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.servicebus.CredentialType</code> type.
         * 
         * Default: CONNECTION_STRING
         * Group: security
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option is a:
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder tokenCredential(com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication.
         * 
         * The option will be converted to a
         * <code>com.azure.core.credential.TokenCredential</code> type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder tokenCredential(String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure ServiceBus component.
     */
    public interface AdvancedServiceBusEndpointBuilder
            extends
                AdvancedServiceBusEndpointConsumerBuilder,
                AdvancedServiceBusEndpointProducerBuilder {
        default ServiceBusEndpointBuilder basic() {
            return (ServiceBusEndpointBuilder) this;
        }

    }

    public interface ServiceBusBuilders {
        /**
         * Azure ServiceBus (camel-azure-servicebus)
         * Send and receive messages to/from Azure Service Bus.
         * 
         * Category: cloud,messaging
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-azure-servicebus
         * 
         * @return the dsl builder for the headers' name.
         */
        default ServiceBusHeaderNameBuilder azureServicebus() {
            return ServiceBusHeaderNameBuilder.INSTANCE;
        }
        /**
         * Azure ServiceBus (camel-azure-servicebus)
         * Send and receive messages to/from Azure Service Bus.
         * 
         * Category: cloud,messaging
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-azure-servicebus
         * 
         * Syntax: <code>azure-servicebus:topicOrQueueName</code>
         * 
         * Path parameter: topicOrQueueName
         * Selected topic name or the queue name, that is depending on
         * serviceBusType config. For example if serviceBusType=queue, then this
         * will be the queue name and if serviceBusType=topic, this will be the
         * topic name.
         * 
         * @param path topicOrQueueName
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder azureServicebus(String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder("azure-servicebus", path);
        }
        /**
         * Azure ServiceBus (camel-azure-servicebus)
         * Send and receive messages to/from Azure Service Bus.
         * 
         * Category: cloud,messaging
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-azure-servicebus
         * 
         * Syntax: <code>azure-servicebus:topicOrQueueName</code>
         * 
         * Path parameter: topicOrQueueName
         * Selected topic name or the queue name, that is depending on
         * serviceBusType config. For example if serviceBusType=queue, then this
         * will be the queue name and if serviceBusType=topic, this will be the
         * topic name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topicOrQueueName
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder azureServicebus(String componentName, String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Azure ServiceBus component.
     */
    public static class ServiceBusHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final ServiceBusHeaderNameBuilder INSTANCE = new ServiceBusHeaderNameBuilder();

        /**
         * The application properties (also known as custom properties) on
         * messages sent and received by the producer and consumer,
         * respectively.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureServiceBusApplicationProperties}.
         */
        public String azureServiceBusApplicationProperties() {
            return "CamelAzureServiceBusApplicationProperties";
        }
        /**
         * Gets the content type of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusContentType}.
         */
        public String azureServiceBusContentType() {
            return "CamelAzureServiceBusContentType";
        }
        /**
         * Gets the description for a message that has been dead-lettered.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureServiceBusDeadLetterErrorDescription}.
         */
        public String azureServiceBusDeadLetterErrorDescription() {
            return "CamelAzureServiceBusDeadLetterErrorDescription";
        }
        /**
         * Gets the reason a message was dead-lettered.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureServiceBusDeadLetterReason}.
         */
        public String azureServiceBusDeadLetterReason() {
            return "CamelAzureServiceBusDeadLetterReason";
        }
        /**
         * Gets the name of the queue or subscription that this message was
         * enqueued on, before it was dead-lettered.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureServiceBusDeadLetterSource}.
         */
        public String azureServiceBusDeadLetterSource() {
            return "CamelAzureServiceBusDeadLetterSource";
        }
        /**
         * Gets the number of the times this message was delivered to clients.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusDeliveryCount}.
         */
        public String azureServiceBusDeliveryCount() {
            return "CamelAzureServiceBusDeliveryCount";
        }
        /**
         * Gets the enqueued sequence number assigned to a message by Service
         * Bus.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureServiceBusEnqueuedSequenceNumber}.
         */
        public String azureServiceBusEnqueuedSequenceNumber() {
            return "CamelAzureServiceBusEnqueuedSequenceNumber";
        }
        /**
         * Gets the datetime at which this message was enqueued in Azure Service
         * Bus.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusEnqueuedTime}.
         */
        public String azureServiceBusEnqueuedTime() {
            return "CamelAzureServiceBusEnqueuedTime";
        }
        /**
         * Gets the datetime at which this message will expire.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusExpiresAt}.
         */
        public String azureServiceBusExpiresAt() {
            return "CamelAzureServiceBusExpiresAt";
        }
        /**
         * Gets the lock token for the current message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusLockToken}.
         */
        public String azureServiceBusLockToken() {
            return "CamelAzureServiceBusLockToken";
        }
        /**
         * Gets the datetime at which the lock of this message expires.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusLockedUntil}.
         */
        public String azureServiceBusLockedUntil() {
            return "CamelAzureServiceBusLockedUntil";
        }
        /**
         * Gets the identifier for the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusMessageId}.
         */
        public String azureServiceBusMessageId() {
            return "CamelAzureServiceBusMessageId";
        }
        /**
         * Gets the partition key for sending a message to a partitioned entity.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusPartitionKey}.
         */
        public String azureServiceBusPartitionKey() {
            return "CamelAzureServiceBusPartitionKey";
        }
        /**
         * The representation of message as defined by AMQP protocol.
         * 
         * The option is a: {@code AmqpAnnotatedMessage} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusRawAmqpMessage}.
         */
        public String azureServiceBusRawAmqpMessage() {
            return "CamelAzureServiceBusRawAmqpMessage";
        }
        /**
         * Gets the address of an entity to send replies to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusReplyTo}.
         */
        public String azureServiceBusReplyTo() {
            return "CamelAzureServiceBusReplyTo";
        }
        /**
         * Gets or sets a session identifier augmenting the ReplyTo address.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureServiceBusReplyToSessionId}.
         */
        public String azureServiceBusReplyToSessionId() {
            return "CamelAzureServiceBusReplyToSessionId";
        }
        /**
         * Gets the unique number assigned to a message by Service Bus.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusSequenceNumber}.
         */
        public String azureServiceBusSequenceNumber() {
            return "CamelAzureServiceBusSequenceNumber";
        }
        /**
         * Gets the session id of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusSessionId}.
         */
        public String azureServiceBusSessionId() {
            return "CamelAzureServiceBusSessionId";
        }
        /**
         * Gets the subject for the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusSubject}.
         */
        public String azureServiceBusSubject() {
            return "CamelAzureServiceBusSubject";
        }
        /**
         * Gets the duration before this message expires.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusTimeToLive}.
         */
        public String azureServiceBusTimeToLive() {
            return "CamelAzureServiceBusTimeToLive";
        }
        /**
         * Gets the to address.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureServiceBusTo}.
         */
        public String azureServiceBusTo() {
            return "CamelAzureServiceBusTo";
        }
        /**
         * (producer)Overrides the OffsetDateTime at which the message should
         * appear in the Service Bus queue or topic. (consumer) Gets the
         * scheduled enqueue time of this message.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureServiceBusScheduledEnqueueTime}.
         */
        public String azureServiceBusScheduledEnqueueTime() {
            return "CamelAzureServiceBusScheduledEnqueueTime";
        }
        /**
         * Overrides the transaction in service. This object just contains
         * transaction id.
         * 
         * The option is a: {@code ServiceBusTransactionContext} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureServiceBusServiceBusTransactionContext}.
         */
        public String azureServiceBusServiceBusTransactionContext() {
            return "CamelAzureServiceBusServiceBusTransactionContext";
        }
        /**
         * Overrides the desired operation to be used in the producer.
         * 
         * The option is a: {@code
         * org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureServiceBusProducerOperation}.
         */
        public String azureServiceBusProducerOperation() {
            return "CamelAzureServiceBusProducerOperation";
        }
        /**
         * Gets or Sets a correlation identifier.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureServiceBusCorrelationId}.
         */
        public String azureServiceBusCorrelationId() {
            return "CamelAzureServiceBusCorrelationId";
        }
    }
    static ServiceBusEndpointBuilder endpointBuilder(String componentName, String path) {
        class ServiceBusEndpointBuilderImpl extends AbstractEndpointBuilder implements ServiceBusEndpointBuilder, AdvancedServiceBusEndpointBuilder {
            public ServiceBusEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ServiceBusEndpointBuilderImpl(path);
    }
}