/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.PipeSpec;
import org.apache.camel.v1.pipespec.ErrorHandler;
import org.apache.camel.v1.pipespec.ErrorHandlerBuilder;
import org.apache.camel.v1.pipespec.ErrorHandlerFluent;
import org.apache.camel.v1.pipespec.Integration;
import org.apache.camel.v1.pipespec.IntegrationBuilder;
import org.apache.camel.v1.pipespec.IntegrationFluent;
import org.apache.camel.v1.pipespec.Sink;
import org.apache.camel.v1.pipespec.SinkBuilder;
import org.apache.camel.v1.pipespec.SinkFluent;
import org.apache.camel.v1.pipespec.Source;
import org.apache.camel.v1.pipespec.SourceBuilder;
import org.apache.camel.v1.pipespec.SourceFluent;
import org.apache.camel.v1.pipespec.Steps;
import org.apache.camel.v1.pipespec.StepsBuilder;
import org.apache.camel.v1.pipespec.StepsFluent;

public class PipeSpecFluent<A extends PipeSpecFluent<A>>
extends BaseFluent<A> {
    private ErrorHandlerBuilder errorHandler;
    private IntegrationBuilder integration;
    private Integer replicas;
    private String serviceAccountName;
    private SinkBuilder sink;
    private SourceBuilder source;
    private ArrayList<StepsBuilder> steps;

    public PipeSpecFluent() {
    }

    public PipeSpecFluent(PipeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PipeSpec instance) {
        PipeSpec pipeSpec = instance = instance != null ? instance : new PipeSpec();
        if (instance != null) {
            this.withErrorHandler(instance.getErrorHandler());
            this.withIntegration(instance.getIntegration());
            this.withReplicas(instance.getReplicas());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSink(instance.getSink());
            this.withSource(instance.getSource());
            this.withSteps(instance.getSteps());
        }
    }

    public ErrorHandler buildErrorHandler() {
        return this.errorHandler != null ? this.errorHandler.build() : null;
    }

    public A withErrorHandler(ErrorHandler errorHandler) {
        this._visitables.remove((Object)"errorHandler");
        if (errorHandler != null) {
            this.errorHandler = new ErrorHandlerBuilder(errorHandler);
            this._visitables.get((Object)"errorHandler").add(this.errorHandler);
        } else {
            this.errorHandler = null;
            this._visitables.get((Object)"errorHandler").remove((Object)this.errorHandler);
        }
        return (A)((Object)this);
    }

    public boolean hasErrorHandler() {
        return this.errorHandler != null;
    }

    public ErrorHandlerNested<A> withNewErrorHandler() {
        return new ErrorHandlerNested(null);
    }

    public ErrorHandlerNested<A> withNewErrorHandlerLike(ErrorHandler item) {
        return new ErrorHandlerNested(item);
    }

    public ErrorHandlerNested<A> editPipespecErrorHandler() {
        return this.withNewErrorHandlerLike(Optional.ofNullable(this.buildErrorHandler()).orElse(null));
    }

    public ErrorHandlerNested<A> editOrNewErrorHandler() {
        return this.withNewErrorHandlerLike(Optional.ofNullable(this.buildErrorHandler()).orElse(new ErrorHandlerBuilder().build()));
    }

    public ErrorHandlerNested<A> editOrNewErrorHandlerLike(ErrorHandler item) {
        return this.withNewErrorHandlerLike(Optional.ofNullable(this.buildErrorHandler()).orElse(item));
    }

    public Integration buildIntegration() {
        return this.integration != null ? this.integration.build() : null;
    }

    public A withIntegration(Integration integration) {
        this._visitables.remove((Object)"integration");
        if (integration != null) {
            this.integration = new IntegrationBuilder(integration);
            this._visitables.get((Object)"integration").add(this.integration);
        } else {
            this.integration = null;
            this._visitables.get((Object)"integration").remove((Object)this.integration);
        }
        return (A)((Object)this);
    }

    public boolean hasIntegration() {
        return this.integration != null;
    }

    public IntegrationNested<A> withNewIntegration() {
        return new IntegrationNested(null);
    }

    public IntegrationNested<A> withNewIntegrationLike(Integration item) {
        return new IntegrationNested(item);
    }

    public IntegrationNested<A> editPipespecIntegration() {
        return this.withNewIntegrationLike(Optional.ofNullable(this.buildIntegration()).orElse(null));
    }

    public IntegrationNested<A> editOrNewIntegration() {
        return this.withNewIntegrationLike(Optional.ofNullable(this.buildIntegration()).orElse(new IntegrationBuilder().build()));
    }

    public IntegrationNested<A> editOrNewIntegrationLike(Integration item) {
        return this.withNewIntegrationLike(Optional.ofNullable(this.buildIntegration()).orElse(item));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Sink buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public A withSink(Sink sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new SinkBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Sink item) {
        return new SinkNested(item);
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new SinkBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Sink item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public Source buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(Source source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new SourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(Source item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new SourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(Source item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public A addToSteps(int index, Steps item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepsBuilder builder = new StepsBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").add(index, builder);
            this.steps.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSteps(int index, Steps item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepsBuilder builder = new StepsBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").set(index, builder);
            this.steps.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSteps(Steps ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (Steps item : items) {
            StepsBuilder builder = new StepsBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSteps(Collection<Steps> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (Steps item : items) {
            StepsBuilder builder = new StepsBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSteps(Steps ... items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (Steps item : items) {
            StepsBuilder builder = new StepsBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSteps(Collection<Steps> items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (Steps item : items) {
            StepsBuilder builder = new StepsBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSteps(Predicate<StepsBuilder> predicate) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        Iterator<StepsBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            StepsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Steps> buildSteps() {
        return this.steps != null ? PipeSpecFluent.build(this.steps) : null;
    }

    public Steps buildStep(int index) {
        return this.steps.get(index).build();
    }

    public Steps buildFirstStep() {
        return this.steps.get(0).build();
    }

    public Steps buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    public Steps buildMatchingStep(Predicate<StepsBuilder> predicate) {
        for (StepsBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStep(Predicate<StepsBuilder> predicate) {
        for (StepsBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSteps(List<Steps> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").clear();
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (Steps item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)((Object)this);
    }

    public A withSteps(Steps ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove((Object)"steps");
        }
        if (steps != null) {
            for (Steps item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public StepsNested<A> addNewStep() {
        return new StepsNested(-1, null);
    }

    public StepsNested<A> addNewStepLike(Steps item) {
        return new StepsNested(-1, item);
    }

    public StepsNested<A> setNewStepLike(int index, Steps item) {
        return new StepsNested(index, item);
    }

    public StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException("Can't edit steps. Index exceeds size.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException("Can't edit first steps. The list is empty.");
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    public StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last steps. The list is empty.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public StepsNested<A> editMatchingStep(Predicate<StepsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching steps. No match found.");
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipeSpecFluent that = (PipeSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.errorHandler, (Object)that.errorHandler)) {
            return false;
        }
        if (!Objects.equals((Object)this.integration, (Object)that.integration)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorHandler, this.integration, this.replicas, this.serviceAccountName, this.sink, this.source, this.steps, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.errorHandler != null) {
            sb.append("errorHandler:");
            sb.append(this.errorHandler + ",");
        }
        if (this.integration != null) {
            sb.append("integration:");
            sb.append(this.integration + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append(this.sink + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ErrorHandlerNested<N>
    extends ErrorHandlerFluent<ErrorHandlerNested<N>>
    implements Nested<N> {
        ErrorHandlerBuilder builder;

        ErrorHandlerNested(ErrorHandler item) {
            this.builder = new ErrorHandlerBuilder(this, item);
        }

        public N and() {
            return (N)PipeSpecFluent.this.withErrorHandler(this.builder.build());
        }

        public N endPipespecErrorHandler() {
            return this.and();
        }
    }

    public class IntegrationNested<N>
    extends IntegrationFluent<IntegrationNested<N>>
    implements Nested<N> {
        IntegrationBuilder builder;

        IntegrationNested(Integration item) {
            this.builder = new IntegrationBuilder(this, item);
        }

        public N and() {
            return (N)PipeSpecFluent.this.withIntegration(this.builder.build());
        }

        public N endPipespecIntegration() {
            return this.and();
        }
    }

    public class SinkNested<N>
    extends SinkFluent<SinkNested<N>>
    implements Nested<N> {
        SinkBuilder builder;

        SinkNested(Sink item) {
            this.builder = new SinkBuilder(this, item);
        }

        public N and() {
            return (N)PipeSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends SourceFluent<SourceNested<N>>
    implements Nested<N> {
        SourceBuilder builder;

        SourceNested(Source item) {
            this.builder = new SourceBuilder(this, item);
        }

        public N and() {
            return (N)PipeSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class StepsNested<N>
    extends StepsFluent<StepsNested<N>>
    implements Nested<N> {
        StepsBuilder builder;
        int index;

        StepsNested(int index, Steps item) {
            this.index = index;
            this.builder = new StepsBuilder(this, item);
        }

        public N and() {
            return (N)PipeSpecFluent.this.setToSteps(this.index, this.builder.build());
        }

        public N endStep() {
            return this.and();
        }
    }
}

