/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.async;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.testing.redirect.Redirect;
import org.apache.hc.client5.testing.redirect.RedirectResolver;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class RedirectingAsyncDecorator
implements AsyncServerExchangeHandler {
    private final AsyncServerExchangeHandler exchangeHandler;
    private final RedirectResolver redirectResolver;
    private final AtomicBoolean redirecting;

    public RedirectingAsyncDecorator(AsyncServerExchangeHandler exchangeHandler, RedirectResolver redirectResolver) {
        this.exchangeHandler = (AsyncServerExchangeHandler)Args.notNull((Object)exchangeHandler, (String)"Exchange handler");
        this.redirectResolver = redirectResolver;
        this.redirecting = new AtomicBoolean();
    }

    private Redirect resolveRedirect(HttpRequest request) throws HttpException {
        try {
            URI requestURI = request.getUri();
            return this.redirectResolver != null ? this.redirectResolver.resolve(requestURI) : null;
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
    }

    private HttpResponse createRedirectResponse(Redirect redirect) {
        BasicHttpResponse response = new BasicHttpResponse(redirect.status);
        if (redirect.location != null) {
            response.addHeader((Header)new BasicHeader("Location", (Object)redirect.location));
        }
        switch (redirect.connControl) {
            case KEEP_ALIVE: {
                response.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
                break;
            }
            case CLOSE: {
                response.addHeader((Header)new BasicHeader("Connection", (Object)"close"));
            }
        }
        return response;
    }

    public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
        Redirect redirect = this.resolveRedirect(request);
        if (redirect != null) {
            responseChannel.sendResponse(this.createRedirectResponse(redirect), null, context);
            this.redirecting.set(true);
        } else {
            this.exchangeHandler.handleRequest(request, entityDetails, responseChannel, context);
        }
    }

    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        if (!this.redirecting.get()) {
            this.exchangeHandler.updateCapacity(capacityChannel);
        } else {
            capacityChannel.update(Integer.MAX_VALUE);
        }
    }

    public final void consume(ByteBuffer src) throws IOException {
        if (!this.redirecting.get()) {
            this.exchangeHandler.consume(src);
        }
    }

    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (!this.redirecting.get()) {
            this.exchangeHandler.streamEnd(trailers);
        }
    }

    public int available() {
        return this.redirecting.get() ? 0 : this.exchangeHandler.available();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (!this.redirecting.get()) {
            this.exchangeHandler.produce(channel);
        }
    }

    public void failed(Exception cause) {
        if (!this.redirecting.get()) {
            this.exchangeHandler.failed(cause);
        }
    }

    public void releaseResources() {
        this.exchangeHandler.releaseResources();
    }
}

