/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.util.Arrays;

public class CacheState {
    private int[] parts;
    private long[] vals;
    private byte[] states;
    private int idx;

    public CacheState(int partsCnt) {
        this.parts = new int[partsCnt];
        this.vals = new long[partsCnt * 2];
        this.states = new byte[partsCnt];
    }

    public void addPartitionState(int partId, long size, long cntr) {
        this.addPartitionState(partId, size, cntr, (byte)-1);
    }

    public void addPartitionState(int partId, long size, long cntr, byte state) {
        if (this.idx == this.parts.length) {
            throw new IllegalStateException("Failed to add new partition to the partitions state (no enough space reserved) [partId=" + partId + ", reserved=" + this.parts.length + "]");
        }
        if (this.idx > 0 && this.parts[this.idx - 1] >= partId) {
            throw new IllegalStateException("Adding partition in a wrong order [prev=" + this.parts[this.idx - 1] + ", cur=" + partId + "]");
        }
        this.parts[this.idx] = partId;
        this.states[this.idx] = state;
        this.vals[2 * this.idx] = size;
        this.vals[2 * this.idx + 1] = cntr;
        ++this.idx;
    }

    public long sizeByPartition(int partId) {
        int idx = this.indexByPartition(partId);
        return idx >= 0 ? this.vals[2 * idx] : -1L;
    }

    public long counterByPartition(int partId) {
        int idx = this.indexByPartition(partId);
        return idx >= 0 ? this.vals[2 * idx + 1] : 0L;
    }

    public int partitionByIndex(int idx) {
        return this.parts[idx];
    }

    public byte stateByIndex(int idx) {
        return this.states[idx];
    }

    public long partitionSizeByIndex(int idx) {
        return this.vals[idx * 2];
    }

    public long partitionCounterByIndex(int idx) {
        return this.vals[idx * 2 + 1];
    }

    public int size() {
        return this.idx;
    }

    private int indexByPartition(int partId) {
        return Arrays.binarySearch(this.parts, 0, this.idx, partId);
    }

    public String toString() {
        return "CacheState [cap=" + this.parts.length + ", size=" + this.idx + "]";
    }
}

