/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.tree.io;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.jetbrains.annotations.Nullable;

public abstract class BplusInnerIo<L>
extends BplusIo<L> {
    private static final int SHIFT_LEFT = 56;
    private static final int SHIFT_LINK = 62;
    public static final int CHILD_LINK_SIZE = 6;
    private final int shiftRight;

    protected BplusInnerIo(int type, int ver, boolean canGetRow, int itemSize) {
        super(type, ver, false, canGetRow, itemSize);
        this.shiftRight = 62 + this.itemSize;
    }

    @Override
    public int getMaxCount(long pageAddr, int pageSize) {
        return (pageSize - 56 - 6) / (this.getItemSize() + 6);
    }

    public final long getLeft(long pageAddr, int idx, int partId) {
        return PartitionlessLinks.readPartitionless(partId, pageAddr, this.offset0(idx, 56));
    }

    public final void setLeft(long pageAddr, int idx, long pageId) {
        this.assertPageType(pageAddr);
        PartitionlessLinks.writePartitionless(pageAddr + (long)this.offset0(idx, 56), pageId);
        assert (pageId == this.getLeft(pageAddr, idx, PageIdUtils.partitionId(pageId)));
    }

    public final long getRight(long pageAddr, int idx, int partId) {
        return PartitionlessLinks.readPartitionless(partId, pageAddr, this.offset0(idx, this.shiftRight));
    }

    private void setRight(long pageAddr, int idx, long pageId) {
        this.assertPageType(pageAddr);
        PartitionlessLinks.writePartitionless(pageAddr + (long)this.offset0(idx, this.shiftRight), pageId);
        assert (pageId == this.getRight(pageAddr, idx, PageIdUtils.partitionId(pageId)));
    }

    @Override
    public final void copyItems(long srcPageAddr, long dstPageAddr, int srcIdx, int dstIdx, int cnt, boolean cpLeft) {
        this.assertPageType(dstPageAddr);
        assert (srcIdx != dstIdx || srcPageAddr != dstPageAddr);
        cnt *= this.getItemSize() + 6;
        if (dstIdx > srcIdx) {
            PageUtils.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)cnt);
            if (cpLeft) {
                long leftPageId = PartitionlessLinks.readPartitionless(-1, srcPageAddr, this.offset0(srcIdx, 56));
                PartitionlessLinks.writePartitionless(dstPageAddr + (long)this.offset0(dstIdx, 56), leftPageId);
            }
        } else {
            if (cpLeft) {
                long leftPageId = PartitionlessLinks.readPartitionless(-1, srcPageAddr, this.offset0(srcIdx, 56));
                PartitionlessLinks.writePartitionless(dstPageAddr + (long)this.offset0(dstIdx, 56), leftPageId);
            }
            PageUtils.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)cnt);
        }
    }

    private int offset0(int idx, int shift) {
        return shift + (6 + this.getItemSize()) * idx;
    }

    @Override
    public final int offset(int idx) {
        return this.offset0(idx, 62);
    }

    @Override
    @Nullable
    public byte[] insert(long pageAddr, int idx, L row, @Nullable byte[] rowBytes, long rightId, boolean needRowBytes) throws IgniteInternalCheckedException {
        this.assertPageType(pageAddr);
        rowBytes = super.insert(pageAddr, idx, row, rowBytes, rightId, needRowBytes);
        this.setRight(pageAddr, idx, rightId);
        return rowBytes;
    }

    public byte @Nullable [] initNewRoot(long newRootPageAddr, long newRootId, long leftChildId, L row, byte @Nullable [] rowBytes, long rightChildId, int pageSize, boolean needRowBytes) throws IgniteInternalCheckedException {
        this.initNewPage(newRootPageAddr, newRootId, pageSize);
        this.setCount(newRootPageAddr, 1);
        this.setLeft(newRootPageAddr, 0, leftChildId);
        rowBytes = this.store(newRootPageAddr, 0, row, rowBytes, needRowBytes);
        this.setRight(newRootPageAddr, 0, rightChildId);
        return rowBytes;
    }
}

