/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.DefaultValueGenerator;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public final class CatalogToSchemaDescriptorConverter {
    private static final Map<String, NativeType> FIX_SIZED_TYPES;

    public static NativeType convertType(CatalogTableColumnDescriptor columnDescriptor) {
        String typeName = columnDescriptor.type().name();
        NativeType res = FIX_SIZED_TYPES.get(typeName);
        if (res != null) {
            return res;
        }
        switch (typeName) {
            case "STRING": {
                int strLen = columnDescriptor.length();
                return NativeTypes.stringOf(strLen);
            }
            case "BYTE_ARRAY": {
                int blobLen = columnDescriptor.length();
                return NativeTypes.blobOf(blobLen);
            }
            case "DECIMAL": {
                int prec = columnDescriptor.precision();
                int scale = columnDescriptor.scale();
                return NativeTypes.decimalOf(prec, scale);
            }
            case "TIME": {
                return NativeTypes.time(columnDescriptor.precision());
            }
            case "DATETIME": {
                return NativeTypes.datetime(columnDescriptor.precision());
            }
            case "TIMESTAMP": {
                return NativeTypes.timestamp(columnDescriptor.precision());
            }
        }
        throw new IllegalArgumentException("Unknown type " + typeName);
    }

    public static Column convert(CatalogTableColumnDescriptor columnDescriptor) {
        DefaultValueProvider defaultValueProvider;
        NativeType type = CatalogToSchemaDescriptorConverter.convertType(columnDescriptor);
        DefaultValue defaultValue = columnDescriptor.defaultValue();
        if (defaultValue == null) {
            defaultValueProvider = DefaultValueProvider.NULL_PROVIDER;
        } else if (defaultValue.type() == DefaultValue.Type.CONSTANT) {
            DefaultValue.ConstantValue constantValue = (DefaultValue.ConstantValue)defaultValue;
            defaultValueProvider = DefaultValueProvider.constantProvider(constantValue.value());
        } else if (defaultValue.type() == DefaultValue.Type.FUNCTION_CALL) {
            DefaultValue.FunctionCall functionCall = (DefaultValue.FunctionCall)defaultValue;
            defaultValueProvider = DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(functionCall.functionName()));
        } else {
            throw new IllegalStateException("Unknown value supplier class " + defaultValue.getClass().getName());
        }
        return new Column(columnDescriptor.name(), type, columnDescriptor.nullable(), defaultValueProvider);
    }

    public static SchemaDescriptor convert(CatalogTableDescriptor tableDescriptor, int tableVersion) {
        SchemaDescriptor descriptorOrNull = CatalogToSchemaDescriptorConverter.convertIfExists(tableDescriptor, tableVersion);
        assert (descriptorOrNull != null) : IgniteStringFormatter.format("Cannot find table version {} in table descriptor {}", tableVersion, tableDescriptor);
        return descriptorOrNull;
    }

    @Nullable
    public static SchemaDescriptor convertIfExists(CatalogTableDescriptor tableDescriptor, int tableVersion) {
        ArrayList<Column> columns = new ArrayList<Column>(tableDescriptor.columns().size());
        CatalogTableSchemaVersions.TableVersion tableVersionInstance = tableDescriptor.schemaVersions().get(tableVersion);
        if (tableVersionInstance == null) {
            return null;
        }
        for (CatalogTableColumnDescriptor column : tableVersionInstance.columns()) {
            columns.add(CatalogToSchemaDescriptorConverter.convert(column));
        }
        return new SchemaDescriptor(tableVersion, columns, tableDescriptor.primaryKeyColumns(), tableDescriptor.colocationColumns());
    }

    private CatalogToSchemaDescriptorConverter() {
    }

    static {
        List<NativeType> types = IgniteUtils.collectStaticFields(NativeTypes.class, NativeType.class);
        HashMap<String, NativeType> tmp = new HashMap<String, NativeType>(types.size(), 1.0f);
        for (NativeType type : types) {
            if (!type.fixedLength()) continue;
            tmp.put(type.spec().name(), type);
        }
        FIX_SIZED_TYPES = Map.copyOf(tmp);
    }
}

